/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import com.sk89q.mclauncher.util.AbstractDownloader;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URLConnectionDownloader
extends AbstractDownloader {
    private static final int READ_BUFFER_SIZE = 8192;
    private long length;
    private long readLength;
    private String etag;
    private HttpURLConnection conn;

    public URLConnectionDownloader(URL url, OutputStream output) {
        super(url, output);
    }

    public HttpURLConnection getConnection() {
        if (this.conn == null) {
            throw new IllegalArgumentException("Connection does not currently exist");
        }
        return this.conn;
    }

    @Override
    public long getTotalLength() {
        return this.length;
    }

    @Override
    public long getDownloadedLength() {
        return this.readLength;
    }

    @Override
    public String getEtag() {
        return this.etag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean download() throws IOException, InterruptedException {
        this.conn = null;
        BufferedInputStream buffInput = null;
        this.length = -1L;
        try {
            this.conn = (HttpURLConnection)URLConnectionDownloader.fixURL(this.getUrl()).openConnection();
            this.conn.setRequestMethod("GET");
            if (this.getEtagCheck() != null) {
                this.conn.setRequestProperty("If-None-Match", "\"" + this.getEtagCheck() + "\"");
            }
            this.conn.setDoOutput(true);
            this.conn.setReadTimeout(this.getTimeout());
            LauncherUtils.checkInterrupted();
            this.conn.connect();
            if (this.conn.getResponseCode() == 304) {
                if (this.getEtagCheck() == null) {
                    throw new IOException("Got unexpected 304 code");
                }
                boolean bl = false;
                return bl;
            }
            if (this.conn.getResponseCode() != 200) {
                throw new IOException("Did not get expected 200 code, got " + this.conn.getResponseCode());
            }
            LauncherUtils.checkInterrupted();
            this.fireConnectionStarted();
            String s = this.conn.getHeaderField("Content-Length");
            if (s != null) {
                try {
                    this.length = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.etag = this.conn.getHeaderField("Etag");
            if (this.etag != null) {
                this.etag = this.etag.matches("^W/") ? null : this.etag.substring(1, this.etag.length() - 1);
            }
            this.fireLengthKnown();
            AbstractDownloader.ProgressEventUpdater progressUpdater = new AbstractDownloader.ProgressEventUpdater(this);
            new Thread(progressUpdater).start();
            try {
                buffInput = new BufferedInputStream(this.conn.getInputStream());
                byte[] data = new byte[8192];
                int len = 0;
                while ((len = buffInput.read(data, 0, 8192)) >= 0 && this.isRunning()) {
                    this.getOutput().write(data, 0, len);
                    if (this.getDigest() != null) {
                        this.getDigest().update(data, 0, len);
                    }
                    this.readLength += (long)len;
                    LauncherUtils.checkInterrupted();
                }
            }
            finally {
                progressUpdater.stop();
            }
            if (this.isRunning()) {
                this.fireDownloadCompleted();
            }
            this.getOutput().close();
            this.conn.disconnect();
        }
        finally {
            this.conn.disconnect();
            buffInput = null;
            this.conn = null;
        }
        return true;
    }

    private static URL fixURL(URL existing) {
        try {
            URL url = new URL(existing.toString());
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            url = uri.toURL();
            return url;
        }
        catch (MalformedURLException e) {
            return existing;
        }
        catch (URISyntaxException e) {
            return existing;
        }
    }
}

