/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import com.sk89q.mclauncher.util.IterableNodeList;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.SimpleNode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static <T> T parseJaxb(Class<T> cls, InputStream in) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{cls});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        Unmarshaller um = context.createUnmarshaller();
        return (T)um.unmarshal(in);
    }

    public static void writeJaxb(Object obj, OutputStream out, Class<?> ... cls) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])cls);
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal(obj, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJaxb(Object obj, File file, Class<?> ... cls) throws JAXBException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            BufferedOutputStream buf = new BufferedOutputStream(fos);
            XmlUtils.writeJaxb(obj, buf, cls);
            buf.close();
        }
        catch (Throwable throwable) {
            LauncherUtils.close(fos);
            throw throwable;
        }
        LauncherUtils.close(fos);
    }

    public static Document parseXml(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        return builder.parse(in);
    }

    public static String getValue(Node node) {
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return "";
        }
        return children.item(0).getNodeValue();
    }

    public static IterableNodeList getNodes(Node node, XPathExpression expr) throws XPathExpressionException {
        return new IterableNodeList((NodeList)expr.evaluate(node, XPathConstants.NODESET));
    }

    public static Node getNode(Node node, XPathExpression expr) throws XPathExpressionException {
        return (Node)expr.evaluate(node, XPathConstants.NODE);
    }

    public static String getString(Node node, XPathExpression expr) throws XPathExpressionException {
        return (String)expr.evaluate(node, XPathConstants.STRING);
    }

    public static String getStringOrNull(Node node, XPathExpression expr) throws XPathExpressionException {
        String s = XmlUtils.getString(node, expr);
        if (s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    public static int getInt(Node node, int def, XPathExpression expr) throws XPathExpressionException {
        String s = XmlUtils.getString(node, expr);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static boolean getBool(Node node, boolean def, XPathExpression expr) throws XPathExpressionException {
        String s = XmlUtils.getStringOrNull(node, expr);
        if (s == null) {
            return def;
        }
        return s.equalsIgnoreCase("true");
    }

    public static String getAttr(Node node, String attr) {
        Node attrNode = node.getAttributes().getNamedItem(attr);
        return attrNode != null ? attrNode.getNodeValue() : "";
    }

    public static String getAttrOrNull(Node node, String attr) {
        Node attrNode = node.getAttributes().getNamedItem(attr);
        return attrNode != null ? attrNode.getNodeValue() : null;
    }

    public static Document newXml() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        return docBuilder.newDocument();
    }

    public static Element addNode(Document doc, Node node, String name) {
        Element element = doc.createElement(name);
        node.appendChild(element);
        return element;
    }

    public static void addText(Document doc, Node node, String text) {
        node.appendChild(doc.createTextNode(text));
    }

    public static Attr setAttr(Document doc, Element node, String name, String text) {
        Attr attr = doc.createAttribute(name);
        attr.setValue(text);
        return node.setAttributeNode(attr);
    }

    public static SimpleNode start(Document doc, String rootNodeName) {
        Element rootElement = doc.createElement(rootNodeName);
        doc.appendChild(rootElement);
        return new SimpleNode(doc, rootElement);
    }

    public static void writeXml(Document doc, File file) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }
}

