/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.migration;

import com.sk89q.bukkit.migration.ConfigurationPermissionsResolver;
import com.sk89q.bukkit.migration.FlatFilePermissionsResolver;
import com.sk89q.bukkit.migration.NijiPermissionsResolver;
import com.sk89q.bukkit.migration.PermissionsProvider;
import com.sk89q.bukkit.migration.PermissionsResolver;
import com.sk89q.bukkit.migration.PluginPermissionsResolver;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.config.Configuration;

public class PermissionsResolverManager
implements PermissionsResolver {
    private Configuration config;
    private Server server;
    private PermissionsResolver perms;
    private String name;
    private Logger logger;

    public PermissionsResolverManager(Configuration config, Server server, String name, Logger logger) {
        this.config = config;
        this.server = server;
        this.name = name;
        this.logger = logger;
        this.findResolver();
    }

    public void findResolver() {
        if (this.tryPluginPermissionsResolver()) {
            return;
        }
        if (this.tryNijiPermissions()) {
            return;
        }
        if (this.tryFlatFilePermissions()) {
            return;
        }
        this.perms = new ConfigurationPermissionsResolver(this.config);
        this.logger.info(this.name + ": No known permissions plugin detected. Using configuration file for permissions.");
    }

    private boolean tryNijiPermissions() {
        try {
            this.perms = new NijiPermissionsResolver(this.server);
            this.logger.info(this.name + ": Permissions plugin detected! Using Permissions plugin for permissions.");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean tryFlatFilePermissions() {
        if (FlatFilePermissionsResolver.filesExists()) {
            this.perms = new FlatFilePermissionsResolver();
            this.logger.info(this.name + ": perms_groups.txt and perms_users.txt detected! Using flat file permissions.");
            return true;
        }
        return false;
    }

    private boolean tryPluginPermissionsResolver() {
        for (Plugin plugin : this.server.getPluginManager().getPlugins()) {
            if (!(plugin instanceof PermissionsProvider)) continue;
            this.perms = new PluginPermissionsResolver((PermissionsProvider)plugin);
            this.logger.info(this.name + ": Using plugin '" + plugin.getDescription().getName() + " for permissions.");
            return true;
        }
        return false;
    }

    public void setPluginPermissionsResolver(Plugin plugin) {
        if (!(plugin instanceof PermissionsProvider)) {
            return;
        }
        this.perms = new PluginPermissionsResolver((PermissionsProvider)plugin);
        this.logger.info(this.name + ": Using plugin '" + plugin.getDescription().getName() + " for permissions.");
    }

    public void load() {
        this.perms.load();
    }

    public boolean hasPermission(String name, String permission) {
        return this.perms.hasPermission(name, permission);
    }

    public boolean inGroup(String player, String group) {
        return this.perms.inGroup(player, group);
    }

    public String[] getGroups(String player) {
        return this.perms.getGroups(player);
    }
}

