/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerQuitEvent;

public class WorldEditPlayerListener
extends PlayerListener {
    private WorldEditPlugin plugin;

    public void onPlayerAnimation(PlayerAnimationEvent event) {
        WorldVector pt;
        BukkitPlayer localPlayer = this.wrapPlayer(event.getPlayer());
        if (event.getAnimationType() == PlayerAnimationType.ARM_SWING) {
            this.plugin.getWorldEdit().handleArmSwing(localPlayer);
        }
        if ((pt = localPlayer.getBlockTrace(5)) == null || pt.getWorld().getBlockType(pt) != 7 || this.plugin.getWorldEdit().handleBlockLeftClick(localPlayer, pt)) {
            // empty if block
        }
    }

    public WorldEditPlayerListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getWorldEdit().handleDisconnect(this.wrapPlayer(event.getPlayer()));
    }

    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String[] split = event.getMessage().split(" ");
        if (this.plugin.getWorldEdit().handleCommand(this.wrapPlayer(event.getPlayer()), split)) {
            event.setCancelled(true);
        }
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            BukkitWorld world = new BukkitWorld(event.getClickedBlock().getWorld());
            WorldVector pos = new WorldVector((LocalWorld)world, event.getClickedBlock().getX(), event.getClickedBlock().getY(), event.getClickedBlock().getZ());
            BukkitPlayer player = this.wrapPlayer(event.getPlayer());
            if (this.plugin.getWorldEdit().handleBlockLeftClick(player, pos)) {
                event.setCancelled(true);
            }
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            BukkitWorld world = new BukkitWorld(event.getClickedBlock().getWorld());
            WorldVector pos = new WorldVector((LocalWorld)world, event.getClickedBlock().getX(), event.getClickedBlock().getY(), event.getClickedBlock().getZ());
            BukkitPlayer player = this.wrapPlayer(event.getPlayer());
            if (this.plugin.getWorldEdit().handleBlockRightClick(player, pos)) {
                event.setCancelled(true);
            }
            if (this.plugin.getWorldEdit().handleRightClick(this.wrapPlayer(event.getPlayer()))) {
                event.setCancelled(true);
            }
        } else if (event.getAction() == Action.RIGHT_CLICK_AIR && this.plugin.getWorldEdit().handleRightClick(this.wrapPlayer(event.getPlayer()))) {
            event.setCancelled(true);
        }
    }

    private BukkitPlayer wrapPlayer(Player player) {
        return new BukkitPlayer(this.plugin, this.plugin.getServerInterface(), player);
    }
}

