/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.regions.Region;
import java.util.Random;

public abstract class LocalWorld {
    protected Random random = new Random();

    public abstract boolean setBlockType(Vector var1, int var2);

    public abstract int getBlockType(Vector var1);

    public abstract void setBlockData(Vector var1, int var2);

    public abstract int getBlockData(Vector var1);

    public abstract int getBlockLightLevel(Vector var1);

    public abstract boolean regenerate(Region var1, EditSession var2);

    public abstract boolean copyToWorld(Vector var1, BaseBlock var2);

    public abstract boolean copyFromWorld(Vector var1, BaseBlock var2);

    public abstract boolean clearContainerBlockContents(Vector var1);

    public abstract boolean generateTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateBigTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateBirchTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateRedwoodTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateTallRedwoodTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public void dropItem(Vector pt, BaseItemStack item, int times) {
        for (int i = 0; i < times; ++i) {
            this.dropItem(pt, item);
        }
    }

    public abstract void dropItem(Vector var1, BaseItemStack var2);

    public void simulateBlockMine(Vector pt) {
        int type = this.getBlockType(pt);
        if (type == 1) {
            this.dropItem(pt, new BaseItemStack(4));
        } else if (type == 2) {
            this.dropItem(pt, new BaseItemStack(3));
        } else if (type != 7 && type != 8 && type != 9 && type != 10 && type != 11) {
            if (type == 13) {
                this.dropItem(pt, new BaseItemStack(type));
                if (this.random.nextDouble() >= 0.9) {
                    this.dropItem(pt, new BaseItemStack(318));
                }
            } else if (type == 16) {
                this.dropItem(pt, new BaseItemStack(263));
            } else if (type == 17) {
                this.dropItem(pt, new BaseItemStack(17, 1, (short)this.getBlockData(pt)));
            } else if (type == 18) {
                if (this.random.nextDouble() > 0.95) {
                    this.dropItem(pt, new BaseItemStack(6));
                }
            } else if (type != 20) {
                if (type == 21) {
                    this.dropItem(pt, new BaseItemStack(351, 1, 4), this.random.nextInt(5) + 4);
                } else if (type == 26) {
                    this.dropItem(pt, new BaseItemStack(355));
                } else if (type == 35) {
                    this.dropItem(pt, new BaseItemStack(35, 1, (short)this.getBlockData(pt)));
                } else if (type == 43) {
                    this.dropItem(pt, new BaseItemStack(44, 1, (short)this.getBlockData(pt)), 2);
                } else if (type == 44) {
                    this.dropItem(pt, new BaseItemStack(44, 1, (short)this.getBlockData(pt)));
                } else if (type != 47 && type != 51 && type != 52) {
                    if (type == 53) {
                        this.dropItem(pt, new BaseItemStack(5));
                    } else if (type == 55) {
                        this.dropItem(pt, new BaseItemStack(331));
                    } else if (type == 56) {
                        this.dropItem(pt, new BaseItemStack(264));
                    } else if (type == 59) {
                        this.dropItem(pt, new BaseItemStack(295));
                    } else if (type == 60) {
                        this.dropItem(pt, new BaseItemStack(3));
                    } else if (type == 62) {
                        this.dropItem(pt, new BaseItemStack(61));
                    } else if (type == 63) {
                        this.dropItem(pt, new BaseItemStack(323));
                    } else if (type == 64) {
                        this.dropItem(pt, new BaseItemStack(324));
                    } else if (type == 67) {
                        this.dropItem(pt, new BaseItemStack(4));
                    } else if (type == 68) {
                        this.dropItem(pt, new BaseItemStack(323));
                    } else if (type == 71) {
                        this.dropItem(pt, new BaseItemStack(330));
                    } else if (type == 73) {
                        this.dropItem(pt, new BaseItemStack(331), this.random.nextInt(2) + 4);
                    } else if (type == 74) {
                        this.dropItem(pt, new BaseItemStack(331), this.random.nextInt(2) + 4);
                    } else if (type == 75) {
                        this.dropItem(pt, new BaseItemStack(76));
                    } else if (type != 78 && type != 79) {
                        if (type == 82) {
                            this.dropItem(pt, new BaseItemStack(337), 4);
                        } else if (type == 83) {
                            this.dropItem(pt, new BaseItemStack(338));
                        } else if (type == 89) {
                            this.dropItem(pt, new BaseItemStack(348));
                        } else if (type != 90) {
                            if (type == 93) {
                                this.dropItem(pt, new BaseItemStack(356));
                            } else if (type == 94) {
                                this.dropItem(pt, new BaseItemStack(356));
                            } else if (type != 0) {
                                this.dropItem(pt, new BaseItemStack(type));
                            }
                        }
                    }
                }
            }
        }
    }

    public abstract int killMobs(Vector var1, int var2);

    public abstract int removeEntities(EntityType var1, Vector var2, int var3);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntityType {
        ARROWS,
        ITEMS,
        PAINTINGS,
        BOATS,
        MINECARTS,
        TNT;

    }
}

