/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.tools;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.ReplacingEditSession;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.masks.Mask;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.patterns.SingleBlockPattern;
import com.sk89q.worldedit.tools.TraceTool;
import com.sk89q.worldedit.tools.brushes.Brush;
import com.sk89q.worldedit.tools.brushes.SphereBrush;

public class BrushTool
implements TraceTool {
    private Mask mask = null;
    private Brush brush = new SphereBrush();
    private Pattern material = new SingleBlockPattern(new BaseBlock(4));
    private int size = 1;

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask filter) {
        this.mask = filter;
    }

    public void setBrush(Brush brush) {
        this.brush = brush;
    }

    public Brush getBrush() {
        return this.brush;
    }

    public void setFill(Pattern material) {
        this.material = material;
    }

    public Pattern getMaterial() {
        return this.material;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean act(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session) {
        WorldVector target = player.getBlockTrace(500);
        if (target == null) {
            player.printError("No block in sight!");
            return true;
        }
        BlockBag bag = session.getBlockBag(player);
        EditSession editSession = this.mask == null ? new EditSession(target.getWorld(), session.getBlockChangeLimit(), bag) : new ReplacingEditSession(target.getWorld(), session.getBlockChangeLimit(), bag, this.mask);
        try {
            this.brush.build(editSession, target, this.material, this.size);
        }
        catch (MaxChangedBlocksException e) {
            player.printError("Max blocks change limit reached.");
        }
        finally {
            if (bag != null) {
                bag.flushChanges();
            }
            session.remember(editSession);
        }
        return true;
    }
}

