/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.migration;

import com.nijikokun.bukkit.Permissions.Permissions;
import com.sk89q.bukkit.migration.PermissionsResolver;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class NijiPermissionsResolver
implements PermissionsResolver {
    private Server server;
    private Permissions api;

    public void load() {
    }

    public NijiPermissionsResolver(Server server) throws PluginAccessException, MissingPluginException {
        this.server = server;
        PluginManager manager = server.getPluginManager();
        Plugin plugin = manager.getPlugin("Permissions");
        if (plugin == null) {
            throw new MissingPluginException();
        }
        try {
            this.api = (Permissions)plugin;
        }
        catch (ClassCastException e) {
            throw new PluginAccessException();
        }
    }

    /*
     * Loose catch block
     */
    public boolean hasPermission(String name, String permission) {
        Player player;
        block5: {
            player = this.server.getPlayer(name);
            if (player != null) break block5;
            return false;
            {
                catch (Throwable t) {
                    t.printStackTrace();
                    return false;
                }
            }
        }
        try {
            return this.api.getHandler().has(player, permission);
        }
        catch (Throwable t) {
            return Permissions.Security.permission(player, permission);
        }
    }

    /*
     * Loose catch block
     */
    public boolean inGroup(String name, String group) {
        Player player;
        block5: {
            player = this.server.getPlayer(name);
            if (player != null) break block5;
            return false;
            {
                catch (Throwable t) {
                    t.printStackTrace();
                    return false;
                }
            }
        }
        try {
            return this.api.getHandler().inGroup(player.getWorld().getName(), name, group);
        }
        catch (Throwable t) {
            return Permissions.Security.inGroup(name, group);
        }
    }

    public String[] getGroups(String name) {
        try {
            String group;
            Player player = this.server.getPlayer(name);
            if (player == null) {
                return new String[0];
            }
            try {
                group = this.api.getHandler().getGroup(player.getWorld().getName(), player.getName());
            }
            catch (Throwable t) {
                group = Permissions.Security.getGroup(player.getName());
            }
            if (group == null) {
                return new String[0];
            }
            return new String[]{group};
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new String[0];
        }
    }

    public static class MissingPluginException
    extends Exception {
        private static final long serialVersionUID = 7044832912491608706L;
    }

    public static class PluginAccessException
    extends Exception {
        private static final long serialVersionUID = 7044832912491608706L;
    }
}

