/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.minecraft.util.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.minecraft.util.commands.CommandUsageException;
import com.sk89q.minecraft.util.commands.MissingNestedCommandException;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.minecraft.util.commands.UnhandledCommandException;
import com.sk89q.minecraft.util.commands.WrappedCommandException;
import com.sk89q.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandsManager<T> {
    protected Map<Method, Map<String, Method>> commands = new HashMap<Method, Map<String, Method>>();
    protected Map<String, String> descs = new HashMap<String, String>();

    public void register(Class<?> cls) {
        this.registerMethods(cls, null);
    }

    private void registerMethods(Class<?> cls, Method parent) {
        Map<Object, Object> map;
        if (this.commands.containsKey(parent)) {
            map = this.commands.get(parent);
        } else {
            map = new HashMap();
            this.commands.put(parent, map);
        }
        for (Method method : cls.getMethods()) {
            if (!method.isAnnotationPresent(Command.class)) continue;
            Command cmd = method.getAnnotation(Command.class);
            for (String alias : cmd.aliases()) {
                map.put(alias, method);
            }
            if (parent == null) {
                if (cmd.usage().length() == 0) {
                    this.descs.put(cmd.aliases()[0], cmd.desc());
                } else {
                    this.descs.put(cmd.aliases()[0], cmd.usage() + " - " + cmd.desc());
                }
            }
            if (!method.isAnnotationPresent(NestedCommand.class)) continue;
            NestedCommand nestedCmd = method.getAnnotation(NestedCommand.class);
            for (Class<?> nestedCls : nestedCmd.value()) {
                this.registerMethods(nestedCls, method);
            }
        }
    }

    public boolean hasCommand(String command) {
        return this.commands.get(null).containsKey(command.toLowerCase());
    }

    public Map<String, String> getCommands() {
        return this.descs;
    }

    protected String getUsage(String[] args, int level, Command cmd) {
        StringBuilder command = new StringBuilder();
        command.append("/");
        for (int i = 0; i <= level; ++i) {
            command.append(args[i] + " ");
        }
        command.append(cmd.flags().length() > 0 ? "[-" + cmd.flags() + "] " : "");
        command.append(cmd.usage());
        return command.toString();
    }

    protected String getNestedUsage(String[] args, int level, Method method, T player) throws CommandException {
        StringBuilder command = new StringBuilder();
        command.append("/");
        for (int i = 0; i <= level; ++i) {
            command.append(args[i] + " ");
        }
        Map<String, Method> map = this.commands.get(method);
        boolean found = false;
        command.append("<");
        HashSet<String> allowedCommands = new HashSet<String>();
        for (Map.Entry<String, Method> entry : map.entrySet()) {
            Method childMethod = entry.getValue();
            found = true;
            if (!this.hasPermission(childMethod, player)) continue;
            Command childCmd = childMethod.getAnnotation(Command.class);
            allowedCommands.add(childCmd.aliases()[0]);
        }
        if (allowedCommands.size() > 0) {
            command.append(StringUtil.joinString(allowedCommands, "|", 0));
        } else if (!found) {
            command.append("?");
        } else {
            throw new CommandPermissionsException();
        }
        command.append(">");
        return command.toString();
    }

    public void execute(String cmd, String[] args, T player, Object ... methodArgs) throws CommandException {
        String[] newArgs = new String[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = cmd;
        Object[] newMethodArgs = new Object[methodArgs.length + 1];
        System.arraycopy(methodArgs, 0, newMethodArgs, 1, methodArgs.length);
        this.executeMethod(null, newArgs, player, newMethodArgs, 0);
    }

    public void execute(String[] args, T player, Object ... methodArgs) throws CommandException {
        Object[] newMethodArgs = new Object[methodArgs.length + 1];
        System.arraycopy(methodArgs, 0, newMethodArgs, 1, methodArgs.length);
        this.executeMethod(null, args, player, newMethodArgs, 0);
    }

    public void executeMethod(Method parent, String[] args, T player, Object[] methodArgs, int level) throws CommandException {
        String cmdName = args[level];
        Map<String, Method> map = this.commands.get(parent);
        Method method = map.get(cmdName.toLowerCase());
        if (method == null) {
            if (parent == null) {
                throw new UnhandledCommandException();
            }
            throw new MissingNestedCommandException("Unknown command: " + cmdName, this.getNestedUsage(args, level - 1, parent, player));
        }
        if (!this.hasPermission(method, player)) {
            throw new CommandPermissionsException();
        }
        int argsCount = args.length - 1 - level;
        if (method.isAnnotationPresent(NestedCommand.class)) {
            if (argsCount == 0) {
                throw new MissingNestedCommandException("Sub-command required.", this.getNestedUsage(args, level, method, player));
            }
            this.executeMethod(method, args, player, methodArgs, level + 1);
        } else {
            Command cmd = method.getAnnotation(Command.class);
            String[] newArgs = new String[args.length - level];
            System.arraycopy(args, level, newArgs, 0, args.length - level);
            CommandContext context = new CommandContext(newArgs);
            if (context.argsLength() < cmd.min()) {
                throw new CommandUsageException("Too few arguments.", this.getUsage(args, level, cmd));
            }
            if (cmd.max() != -1 && context.argsLength() > cmd.max()) {
                throw new CommandUsageException("Too many arguments.", this.getUsage(args, level, cmd));
            }
            for (char flag : context.getFlags()) {
                if (cmd.flags().indexOf(String.valueOf(flag)) != -1) continue;
                throw new CommandUsageException("Unknown flag: " + flag, this.getUsage(args, level, cmd));
            }
            methodArgs[0] = context;
            try {
                method.invoke(null, methodArgs);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CommandException) {
                    throw (CommandException)e.getCause();
                }
                throw new WrappedCommandException(e.getCause());
            }
        }
    }

    protected boolean hasPermission(Method method, T player) {
        CommandPermissions perms = method.getAnnotation(CommandPermissions.class);
        if (perms == null) {
            return true;
        }
        for (String perm : perms.value()) {
            if (!this.hasPermission(player, perm)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean hasPermission(T var1, String var2);
}

