/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.minecraft.util.commands.CommandUsageException;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.minecraft.util.commands.MissingNestedCommandException;
import com.sk89q.minecraft.util.commands.UnhandledCommandException;
import com.sk89q.minecraft.util.commands.WrappedCommandException;
import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.DisallowedItemException;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.FileSelectionAbortedException;
import com.sk89q.worldedit.FilenameException;
import com.sk89q.worldedit.FilenameResolutionException;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.InvalidFilenameException;
import com.sk89q.worldedit.InvalidItemException;
import com.sk89q.worldedit.InvalidToolBindException;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.MaxRadiusException;
import com.sk89q.worldedit.PlayerDirection;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.SessionCheck;
import com.sk89q.worldedit.UnknownDirectionException;
import com.sk89q.worldedit.UnknownItemException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.blocks.ClothColor;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldedit.blocks.MobSpawnerBlock;
import com.sk89q.worldedit.blocks.NoteBlock;
import com.sk89q.worldedit.blocks.SignBlock;
import com.sk89q.worldedit.commands.ChunkCommands;
import com.sk89q.worldedit.commands.ClipboardCommands;
import com.sk89q.worldedit.commands.GeneralCommands;
import com.sk89q.worldedit.commands.GenerationCommands;
import com.sk89q.worldedit.commands.HistoryCommands;
import com.sk89q.worldedit.commands.InsufficientArgumentsException;
import com.sk89q.worldedit.commands.NavigationCommands;
import com.sk89q.worldedit.commands.RegionCommands;
import com.sk89q.worldedit.commands.ScriptingCommands;
import com.sk89q.worldedit.commands.SelectionCommands;
import com.sk89q.worldedit.commands.SnapshotUtilCommands;
import com.sk89q.worldedit.commands.ToolCommands;
import com.sk89q.worldedit.commands.ToolUtilCommands;
import com.sk89q.worldedit.commands.UtilityCommands;
import com.sk89q.worldedit.masks.BlockTypeMask;
import com.sk89q.worldedit.masks.ExistingBlockMask;
import com.sk89q.worldedit.masks.InvertedBlockTypeMask;
import com.sk89q.worldedit.masks.Mask;
import com.sk89q.worldedit.patterns.BlockChance;
import com.sk89q.worldedit.patterns.ClipboardPattern;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.patterns.RandomFillPattern;
import com.sk89q.worldedit.patterns.SingleBlockPattern;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.scripting.CraftScriptContext;
import com.sk89q.worldedit.scripting.RhinoCraftScriptEngine;
import com.sk89q.worldedit.tools.BlockTool;
import com.sk89q.worldedit.tools.DoubleActionBlockTool;
import com.sk89q.worldedit.tools.Tool;
import com.sk89q.worldedit.tools.TraceTool;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.script.ScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldEdit {
    public static final Logger logger = Logger.getLogger("Minecraft.WorldEdit");
    private static String version;
    private ServerInterface server;
    private LocalConfiguration config;
    private CommandsManager<LocalPlayer> commands;
    private HashMap<String, LocalSession> sessions = new HashMap();

    public WorldEdit(ServerInterface server, LocalConfiguration config) {
        this.server = server;
        this.config = config;
        this.commands = new CommandsManager<LocalPlayer>(){

            @Override
            public boolean hasPermission(LocalPlayer player, String perm) {
                return player.hasPermission(perm);
            }
        };
        this.commands.register(ChunkCommands.class);
        this.commands.register(ClipboardCommands.class);
        this.commands.register(GeneralCommands.class);
        this.commands.register(GenerationCommands.class);
        this.commands.register(HistoryCommands.class);
        this.commands.register(NavigationCommands.class);
        this.commands.register(RegionCommands.class);
        this.commands.register(ScriptingCommands.class);
        this.commands.register(SelectionCommands.class);
        this.commands.register(SnapshotUtilCommands.class);
        this.commands.register(ToolUtilCommands.class);
        this.commands.register(ToolCommands.class);
        this.commands.register(UtilityCommands.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalSession getSession(LocalPlayer player) {
        LocalSession session;
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            if (this.sessions.containsKey(player.getName())) {
                return this.sessions.get(player.getName());
            }
            session = new LocalSession(this.config);
            if (!player.hasPermission("worldedit.limit.unrestricted") && this.config.maxChangeLimit > -1) {
                if (this.config.defaultChangeLimit < 0) {
                    session.setBlockChangeLimit(this.config.maxChangeLimit);
                } else {
                    int limit = Math.min(this.config.defaultChangeLimit, this.config.maxChangeLimit);
                    session.setBlockChangeLimit(limit);
                }
            } else {
                session.setBlockChangeLimit(this.config.defaultChangeLimit);
            }
            session.setUseInventory(this.config.useInventory && (!this.config.useInventoryOverride || !player.hasPermission("worldedit.inventory.unrestricted")));
            this.sessions.put(player.getName(), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSession(LocalPlayer player) {
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            return this.sessions.containsKey(player.getName());
        }
    }

    public BaseBlock getBlock(LocalPlayer player, String arg, boolean allAllowed) throws UnknownItemException, DisallowedItemException {
        BlockType blockType;
        int data;
        String testID;
        String[] args1;
        String[] args0;
        block26: {
            arg = arg.replace("_", " ");
            arg = arg.replace(";", "|");
            args0 = arg.split("\\|");
            args1 = args0[0].split(":", 2);
            testID = args1[0];
            data = -1;
            try {
                blockType = BlockType.fromID(Integer.parseInt(testID));
            }
            catch (NumberFormatException e) {
                int t;
                blockType = BlockType.lookup(testID);
                if (blockType != null || (t = this.server.resolveItem(testID)) <= 0 || t >= 256) break block26;
                blockType = BlockType.fromID(t);
            }
        }
        if (blockType == null) {
            ClothColor col = ClothColor.lookup(testID);
            if (col != null) {
                blockType = BlockType.fromID(35);
                data = col.getID();
            } else {
                throw new UnknownItemException(arg);
            }
        }
        if (data == -1) {
            try {
                int n = data = args1.length > 1 ? Integer.parseInt(args1[1]) : 0;
                if (data > 15 || data < 0) {
                    data = 0;
                }
            }
            catch (NumberFormatException e) {
                if (blockType == BlockType.CLOTH) {
                    ClothColor col = ClothColor.lookup(args1[1]);
                    if (col != null) {
                        data = col.getID();
                    }
                    throw new InvalidItemException(arg, "Unknown cloth color '" + args1[1] + "'");
                }
                if (blockType == BlockType.STEP || blockType == BlockType.DOUBLE_STEP) {
                    BlockType dataType = BlockType.lookup(args1[1]);
                    if (dataType != null) {
                        if (dataType == BlockType.STONE) {
                            data = 0;
                        }
                        if (dataType == BlockType.SANDSTONE) {
                            data = 1;
                        }
                        if (dataType == BlockType.WOOD) {
                            data = 2;
                        }
                        if (dataType == BlockType.COBBLESTONE) {
                            data = 3;
                        }
                        throw new InvalidItemException(arg, "Invalid step type '" + args1[1] + "'");
                    }
                    throw new InvalidItemException(arg, "Unknown step type '" + args1[1] + "'");
                }
                throw new InvalidItemException(arg, "Unknown data value '" + args1[1] + "'");
            }
        }
        if (allAllowed || player.hasPermission("worldedit.anyblock") || !this.config.disallowedBlocks.contains(blockType.getID())) {
            if (blockType == BlockType.SIGN_POST || blockType == BlockType.WALL_SIGN) {
                String[] text = new String[]{args0.length > 1 ? args0[1] : "", args0.length > 2 ? args0[2] : "", args0.length > 3 ? args0[3] : "", args0.length > 4 ? args0[4] : ""};
                return new SignBlock(blockType.getID(), data, text);
            }
            if (blockType == BlockType.MOB_SPAWNER) {
                if (args0.length > 1) {
                    String mobName = args0[1];
                    if (mobName.length() > 1) {
                        mobName = mobName.substring(0, 1).toUpperCase() + mobName.substring(1);
                    }
                    if (!this.server.isValidMobType(mobName)) {
                        throw new InvalidItemException(arg, "Unknown mob type '" + mobName + "'");
                    }
                    return new MobSpawnerBlock(data, args0[1]);
                }
                return new MobSpawnerBlock(data, "Pig");
            }
            if (blockType == BlockType.NOTE_BLOCK) {
                if (args0.length > 1) {
                    byte note = Byte.parseByte(args0[1]);
                    if (note < 0 || note > 24) {
                        throw new InvalidItemException(arg, "Out of range note value: '" + args0[1] + "'");
                    }
                    return new NoteBlock(data, note);
                }
                return new NoteBlock(data, 0);
            }
            return new BaseBlock(blockType.getID(), data);
        }
        throw new DisallowedItemException(arg);
    }

    public BaseBlock getBlock(LocalPlayer player, String id) throws UnknownItemException, DisallowedItemException {
        return this.getBlock(player, id, false);
    }

    public Pattern getBlockPattern(LocalPlayer player, String list) throws UnknownItemException, DisallowedItemException {
        String[] items = list.split(",");
        if (list.charAt(0) == '#') {
            if (list.equals("#clipboard") || list.equals("#copy")) {
                CuboidClipboard clipboard;
                LocalSession session = this.getSession(player);
                try {
                    clipboard = session.getClipboard();
                }
                catch (EmptyClipboardException e) {
                    player.printError("Copy a selection first with //copy.");
                    throw new UnknownItemException("#clipboard");
                }
                return new ClipboardPattern(clipboard);
            }
            throw new UnknownItemException(list);
        }
        if (items.length == 1) {
            return new SingleBlockPattern(this.getBlock(player, items[0]));
        }
        ArrayList<BlockChance> blockChances = new ArrayList<BlockChance>();
        for (String s : items) {
            BaseBlock block;
            double chance;
            if (s.matches("[0-9]+(?:\\.(?:[0-9]+)?)?%.*")) {
                String[] p = s.split("%");
                chance = Double.parseDouble(p[0]);
                block = this.getBlock(player, p[1]);
            } else {
                chance = 1.0;
                block = this.getBlock(player, s);
            }
            blockChances.add(new BlockChance(block, chance));
        }
        return new RandomFillPattern(blockChances);
    }

    public Mask getBlockMask(LocalPlayer player, String list) throws UnknownItemException, DisallowedItemException {
        if (list.charAt(0) == '#') {
            if (list.equalsIgnoreCase("#existing")) {
                return new ExistingBlockMask();
            }
            throw new UnknownItemException(list);
        }
        if (list.charAt(0) == '!' && list.length() > 1) {
            return new InvertedBlockTypeMask(this.getBlockIDs(player, list.substring(1), true));
        }
        return new BlockTypeMask(this.getBlockIDs(player, list, true));
    }

    public Set<Integer> getBlockIDs(LocalPlayer player, String list, boolean allBlocksAllowed) throws UnknownItemException, DisallowedItemException {
        String[] items = list.split(",");
        HashSet<Integer> blocks = new HashSet<Integer>();
        for (String s : items) {
            blocks.add(this.getBlock(player, s, allBlocksAllowed).getType());
        }
        return blocks;
    }

    public File getSafeSaveFile(LocalPlayer player, File dir, String filename, String defaultExt, String[] extensions) throws FilenameException {
        return this.getSafeFile(player, dir, filename, defaultExt, extensions, true);
    }

    public File getSafeOpenFile(LocalPlayer player, File dir, String filename, String defaultExt, String[] extensions) throws FilenameException {
        return this.getSafeFile(player, dir, filename, defaultExt, extensions, false);
    }

    private File getSafeFile(LocalPlayer player, File dir, String filename, String defaultExt, String[] extensions, boolean isSave) throws FilenameException {
        File f;
        if (filename.equals("#")) {
            f = isSave ? player.openFileSaveDialog(extensions) : player.openFileOpenDialog(extensions);
            if (f == null) {
                throw new FileSelectionAbortedException("No file selected");
            }
        } else {
            if (defaultExt != null && filename.lastIndexOf(46) == -1) {
                filename = filename + "." + defaultExt;
            }
            if (!filename.matches("^[A-Za-z0-9_\\- \\./\\\\'\\$@~!%\\^\\*\\(\\)\\[\\]\\+\\{\\},\\?]+\\.[A-Za-z0-9]+$")) {
                throw new InvalidFilenameException(filename, "Invalid characters or extension missing");
            }
            f = new File(dir, filename);
        }
        try {
            String filePath = f.getCanonicalPath();
            String dirPath = dir.getCanonicalPath();
            if (!filePath.substring(0, dirPath.length()).equals(dirPath)) {
                throw new FilenameResolutionException(filename, "Path is outside allowable root");
            }
            return f;
        }
        catch (IOException e) {
            throw new FilenameResolutionException(filename, "Failed to resolve path");
        }
    }

    public void checkMaxRadius(int radius) throws MaxRadiusException {
        if (this.config.maxRadius > 0 && radius > this.config.maxRadius) {
            throw new MaxRadiusException();
        }
    }

    public File getWorkingDirectoryFile(String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(this.config.getWorkingDirectory(), path);
    }

    public static int divisorMod(int a, int n) {
        return (int)((double)a - (double)n * Math.floor(Math.floor(a) / (double)n));
    }

    public Vector getDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        int xm = 0;
        int ym = 0;
        int zm = 0;
        PlayerDirection dir = null;
        dirStr = dirStr.toLowerCase();
        boolean wasDetected = false;
        if (dirStr.equals("me")) {
            dir = player.getCardinalDirection();
            wasDetected = true;
        }
        if (dirStr.charAt(0) == 'w' || dir == PlayerDirection.WEST) {
            ++zm;
        } else if (dirStr.charAt(0) == 'e' || dir == PlayerDirection.EAST) {
            --zm;
        } else if (dirStr.charAt(0) == 's' || dir == PlayerDirection.SOUTH) {
            ++xm;
        } else if (dirStr.charAt(0) == 'n' || dir == PlayerDirection.NORTH) {
            --xm;
        } else if (dirStr.charAt(0) == 'u') {
            ++ym;
        } else if (dirStr.charAt(0) == 'd') {
            --ym;
        } else {
            if (wasDetected) {
                throw new UnknownDirectionException(dir.name());
            }
            throw new UnknownDirectionException(dirStr);
        }
        return new Vector(xm, ym, zm);
    }

    public Vector getDiagonalDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        int xm = 0;
        int ym = 0;
        int zm = 0;
        PlayerDirection dir = null;
        dirStr = dirStr.toLowerCase();
        boolean wasDetected = false;
        if (dirStr.equals("me")) {
            dir = player.getCardinalDirection();
            wasDetected = true;
        }
        if (dirStr.charAt(0) == 's' && dirStr.indexOf(119) > 0 || dir == PlayerDirection.SOUTH_WEST) {
            ++zm;
            ++xm;
        } else if (dirStr.charAt(0) == 'n' && dirStr.indexOf(119) > 0 || dir == PlayerDirection.NORTH_WEST) {
            ++zm;
            --xm;
        } else if (dirStr.charAt(0) == 's' && dirStr.indexOf(101) > 0 || dir == PlayerDirection.SOUTH_EAST) {
            --zm;
            ++xm;
        } else if (dirStr.charAt(0) == 'n' && dirStr.indexOf(101) > 0 || dir == PlayerDirection.NORTH_EAST) {
            --zm;
            --xm;
        } else if (dirStr.charAt(0) == 'w' || dir == PlayerDirection.WEST) {
            ++zm;
        } else if (dirStr.charAt(0) == 'e' || dir == PlayerDirection.EAST) {
            --zm;
        } else if (dirStr.charAt(0) == 's' || dir == PlayerDirection.SOUTH) {
            ++xm;
        } else if (dirStr.charAt(0) == 'n' || dir == PlayerDirection.NORTH) {
            --xm;
        } else if (dirStr.charAt(0) == 'u') {
            ++ym;
        } else if (dirStr.charAt(0) == 'd') {
            --ym;
        } else {
            if (wasDetected) {
                throw new UnknownDirectionException(dir.name());
            }
            throw new UnknownDirectionException(dirStr);
        }
        return new Vector(xm, ym, zm);
    }

    public CuboidClipboard.FlipDirection getFlipDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        PlayerDirection dir = null;
        if (dirStr.equals("me")) {
            dir = player.getCardinalDirection();
        }
        if (dirStr.charAt(0) == 'w' || dir == PlayerDirection.EAST) {
            return CuboidClipboard.FlipDirection.WEST_EAST;
        }
        if (dirStr.charAt(0) == 'e' || dir == PlayerDirection.EAST) {
            return CuboidClipboard.FlipDirection.WEST_EAST;
        }
        if (dirStr.charAt(0) == 's' || dir == PlayerDirection.SOUTH) {
            return CuboidClipboard.FlipDirection.NORTH_SOUTH;
        }
        if (dirStr.charAt(0) == 'n' || dir == PlayerDirection.SOUTH) {
            return CuboidClipboard.FlipDirection.NORTH_SOUTH;
        }
        if (dirStr.charAt(0) == 'u') {
            return CuboidClipboard.FlipDirection.UP_DOWN;
        }
        if (dirStr.charAt(0) == 'd') {
            return CuboidClipboard.FlipDirection.UP_DOWN;
        }
        throw new UnknownDirectionException(dir.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(LocalPlayer player) {
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(player.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSessions() {
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.clear();
        }
    }

    public void flushBlockBag(LocalPlayer player, EditSession editSession) {
        Set<Integer> missingBlocks;
        BlockBag blockBag = editSession.getBlockBag();
        if (blockBag != null) {
            blockBag.flushChanges();
        }
        if ((missingBlocks = editSession.popMissingBlocks()).size() > 0) {
            StringBuilder str = new StringBuilder();
            str.append("Missing these blocks: ");
            int size = missingBlocks.size();
            int i = 0;
            for (Integer id : missingBlocks) {
                BlockType type = BlockType.fromID(id);
                str.append(type != null ? type.getName() + " (" + id + ")" : id.toString());
                if (++i == size) continue;
                str.append(", ");
            }
            player.printError(str.toString());
        }
    }

    public Map<String, String> getCommands() {
        return this.commands.getCommands();
    }

    @Deprecated
    public void handleDisconnect(LocalPlayer player) {
        this.forgetPlayer(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markExpire(LocalPlayer player) {
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            LocalSession session = this.sessions.get(player.getName());
            if (session != null) {
                session.update();
            }
        }
    }

    public void forgetPlayer(LocalPlayer player) {
        this.removeSession(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushExpiredSessions(SessionCheck checker) {
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            Iterator<Map.Entry<String, LocalSession>> it = this.sessions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, LocalSession> entry = it.next();
                if (!entry.getValue().hasExpired() || checker.isOnlinePlayer(entry.getKey())) continue;
                it.remove();
            }
        }
    }

    public boolean handleArmSwing(LocalPlayer player) {
        if (player.getItemInHand() == this.config.navigationWand && this.config.navigationWandMaxDistance > 0 && player.hasPermission("worldedit.navigation.jumpto")) {
            WorldVector pos = player.getSolidBlockTrace(this.config.navigationWandMaxDistance);
            if (pos != null) {
                player.findFreePosition(pos);
            } else {
                player.printError("No block in sight (or too far)!");
            }
        }
        return false;
    }

    public boolean handleRightClick(LocalPlayer player) {
        Tool tool;
        LocalSession session = this.getSession(player);
        if (player.getItemInHand() == this.config.navigationWand && this.config.navigationWandMaxDistance > 0 && player.hasPermission("worldedit.navigation.thru") && !player.passThroughForwardWall(40)) {
            player.printError("Nothing to pass through!");
        }
        if ((tool = session.getTool(player.getItemInHand())) != null && tool instanceof TraceTool && tool.canUse(player)) {
            ((TraceTool)tool).act(this.server, this.config, player, session);
            return true;
        }
        return false;
    }

    public boolean handleBlockRightClick(LocalPlayer player, WorldVector clicked) {
        int itemInHand = player.getItemInHand();
        LocalSession session = this.getSession(player);
        if (itemInHand == this.config.wandItem && session.isToolControlEnabled() && player.hasPermission("worldedit.selection.pos")) {
            RegionSelector selector = session.getRegionSelector(player.getWorld());
            if (selector.selectSecondary(clicked)) {
                selector.explainSecondarySelection(player, session, clicked);
            }
            return true;
        }
        Tool tool = session.getTool(player.getItemInHand());
        if (tool != null && tool instanceof BlockTool && tool.canUse(player)) {
            ((BlockTool)tool).actPrimary(this.server, this.config, player, session, clicked);
            return true;
        }
        return false;
    }

    public boolean handleBlockLeftClick(LocalPlayer player, WorldVector clicked) {
        Tool tool;
        LocalSession session = this.getSession(player);
        if (player.getItemInHand() == this.config.wandItem) {
            if (session.isToolControlEnabled() && player.hasPermission("worldedit.selection.pos")) {
                if (clicked.getBlockX() == 0 && clicked.getBlockY() == 0 && clicked.getBlockZ() == 0) {
                    return false;
                }
                RegionSelector selector = session.getRegionSelector(player.getWorld());
                if (selector.selectPrimary(clicked)) {
                    selector.explainPrimarySelection(player, session, clicked);
                }
                return true;
            }
        } else if (player.isHoldingPickAxe() && session.hasSuperPickAxe() && session.getSuperPickaxe() != null && session.getSuperPickaxe().canUse(player)) {
            return session.getSuperPickaxe().actPrimary(this.server, this.config, player, session, clicked);
        }
        if ((tool = session.getTool(player.getItemInHand())) != null && tool instanceof DoubleActionBlockTool && tool.canUse(player)) {
            ((DoubleActionBlockTool)tool).actSecondary(this.server, this.config, player, session, clicked);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleCommand(LocalPlayer player, String[] split) {
        try {
            EditSession editSession;
            block50: {
                String searchCmd;
                split[0] = split[0].substring(1);
                if (split[0].matches("^[^/].*\\.js$")) {
                    String[] newSplit = new String[split.length + 1];
                    System.arraycopy(split, 0, newSplit, 1, split.length);
                    newSplit[0] = "cs";
                    newSplit[1] = newSplit[1];
                    split = newSplit;
                }
                if (!this.commands.hasCommand(searchCmd = split[0].toLowerCase())) {
                    if (this.config.noDoubleSlash && this.commands.hasCommand("/" + searchCmd)) {
                        split[0] = "/" + split[0];
                    } else if (split[0].length() >= 2 && split[0].charAt(0) == '/' && this.commands.hasCommand(searchCmd.substring(1))) {
                        split[0] = split[0].substring(1);
                    }
                }
                if (!this.commands.hasCommand(split[0])) {
                    return false;
                }
                LocalSession session = this.getSession(player);
                BlockBag blockBag = session.getBlockBag(player);
                session.tellVersion(player);
                editSession = new EditSession(player.getWorld(), session.getBlockChangeLimit(), blockBag);
                editSession.enableQueue();
                long start = System.currentTimeMillis();
                try {
                    try {
                        if (this.config.logCommands) {
                            logger.info("WorldEdit: " + player.getName() + ": " + StringUtil.joinString(split, " "));
                        }
                        this.commands.execute(split, player, this, session, player, editSession);
                    }
                    catch (CommandPermissionsException e) {
                        player.printError("You don't have permission to do this.");
                        Object var12_25 = null;
                        session.remember(editSession);
                        editSession.flushQueue();
                        if (this.config.profile) {
                            long time = System.currentTimeMillis() - start;
                            int changed = editSession.getBlockChangeCount();
                            if (time > 0L) {
                                double throughput = (double)changed / ((double)time / 1000.0);
                                player.printDebug((double)time / 1000.0 + "s elapsed (history: " + changed + " changed; " + Math.round(throughput) + " blocks/sec).");
                            } else {
                                player.printDebug((double)time / 1000.0 + "s elapsed.");
                            }
                        }
                        this.flushBlockBag(player, editSession);
                        return true;
                    }
                    catch (MissingNestedCommandException e) {
                        player.printError(e.getUsage());
                        Object var12_26 = null;
                        session.remember(editSession);
                        editSession.flushQueue();
                        if (this.config.profile) {
                            long time = System.currentTimeMillis() - start;
                            int changed = editSession.getBlockChangeCount();
                            if (time > 0L) {
                                double throughput = (double)changed / ((double)time / 1000.0);
                                player.printDebug((double)time / 1000.0 + "s elapsed (history: " + changed + " changed; " + Math.round(throughput) + " blocks/sec).");
                            } else {
                                player.printDebug((double)time / 1000.0 + "s elapsed.");
                            }
                        }
                        this.flushBlockBag(player, editSession);
                        return true;
                    }
                    catch (CommandUsageException e) {
                        player.printError(e.getMessage());
                        player.printError(e.getUsage());
                        Object var12_27 = null;
                        session.remember(editSession);
                        editSession.flushQueue();
                        if (this.config.profile) {
                            long time = System.currentTimeMillis() - start;
                            int changed = editSession.getBlockChangeCount();
                            if (time > 0L) {
                                double throughput = (double)changed / ((double)time / 1000.0);
                                player.printDebug((double)time / 1000.0 + "s elapsed (history: " + changed + " changed; " + Math.round(throughput) + " blocks/sec).");
                            } else {
                                player.printDebug((double)time / 1000.0 + "s elapsed.");
                            }
                        }
                        this.flushBlockBag(player, editSession);
                        return true;
                    }
                    catch (WrappedCommandException e) {
                        throw e.getCause();
                    }
                    catch (UnhandledCommandException e) {
                        boolean bl = false;
                        Object var12_28 = null;
                        session.remember(editSession);
                        editSession.flushQueue();
                        if (this.config.profile) {
                            long time = System.currentTimeMillis() - start;
                            int changed = editSession.getBlockChangeCount();
                            if (time > 0L) {
                                double throughput = (double)changed / ((double)time / 1000.0);
                                player.printDebug((double)time / 1000.0 + "s elapsed (history: " + changed + " changed; " + Math.round(throughput) + " blocks/sec).");
                            } else {
                                player.printDebug((double)time / 1000.0 + "s elapsed.");
                            }
                        }
                        this.flushBlockBag(player, editSession);
                        return bl;
                    }
                    Object var12_24 = null;
                    session.remember(editSession);
                    editSession.flushQueue();
                    if (!this.config.profile) break block50;
                }
                catch (Throwable throwable) {
                    Object var12_29 = null;
                    session.remember(editSession);
                    editSession.flushQueue();
                    if (this.config.profile) {
                        long time = System.currentTimeMillis() - start;
                        int changed = editSession.getBlockChangeCount();
                        if (time > 0L) {
                            double throughput = (double)changed / ((double)time / 1000.0);
                            player.printDebug((double)time / 1000.0 + "s elapsed (history: " + changed + " changed; " + Math.round(throughput) + " blocks/sec).");
                        } else {
                            player.printDebug((double)time / 1000.0 + "s elapsed.");
                        }
                    }
                    this.flushBlockBag(player, editSession);
                    throw throwable;
                }
                long time = System.currentTimeMillis() - start;
                int changed = editSession.getBlockChangeCount();
                if (time > 0L) {
                    double throughput = (double)changed / ((double)time / 1000.0);
                    player.printDebug((double)time / 1000.0 + "s elapsed (history: " + changed + " changed; " + Math.round(throughput) + " blocks/sec).");
                } else {
                    player.printDebug((double)time / 1000.0 + "s elapsed.");
                }
            }
            this.flushBlockBag(player, editSession);
            return true;
        }
        catch (NumberFormatException e) {
            player.printError("Number expected; string given.");
            return true;
        }
        catch (IncompleteRegionException e) {
            player.printError("Make a region selection first.");
            return true;
        }
        catch (UnknownItemException e) {
            player.printError("Block name '" + e.getID() + "' was not recognized.");
            return true;
        }
        catch (InvalidItemException e) {
            player.printError(e.getMessage());
            return true;
        }
        catch (DisallowedItemException e) {
            player.printError("Block '" + e.getID() + "' not allowed (see WorldEdit configuration).");
            return true;
        }
        catch (MaxChangedBlocksException e) {
            player.printError("Max blocks changed in an operation reached (" + e.getBlockLimit() + ").");
            return true;
        }
        catch (MaxRadiusException e) {
            player.printError("Maximum radius: " + this.config.maxRadius);
            return true;
        }
        catch (UnknownDirectionException e) {
            player.printError("Unknown direction: " + e.getDirection());
            return true;
        }
        catch (InsufficientArgumentsException e) {
            player.printError(e.getMessage());
            return true;
        }
        catch (EmptyClipboardException e) {
            player.printError("Your clipboard is empty. Use //copy first.");
            return true;
        }
        catch (InvalidFilenameException e) {
            player.printError("Filename '" + e.getFilename() + "' invalid: " + e.getMessage());
            return true;
        }
        catch (FilenameResolutionException e) {
            player.printError("File '" + e.getFilename() + "' resolution error: " + e.getMessage());
            return true;
        }
        catch (InvalidToolBindException e) {
            player.printError("Can't bind tool to " + ItemType.toHeldName(e.getItemId()) + ": " + e.getMessage());
            return true;
        }
        catch (FileSelectionAbortedException e) {
            player.printError("File selection aborted.");
            return true;
        }
        catch (WorldEditException e) {
            player.printError(e.getMessage());
            return true;
        }
        catch (Throwable excp) {
            player.printError("Please report this error: [See console]");
            player.printRaw(excp.getClass().getName() + ": " + excp.getMessage());
            excp.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runScript(LocalPlayer player, File f, String[] args) throws WorldEditException {
        Iterator<EditSession> i$2;
        String script;
        int index;
        String filename = f.getPath();
        String ext = filename.substring((index = filename.lastIndexOf(".")) + 1, filename.length());
        if (!ext.equalsIgnoreCase("js")) {
            player.printError("Only .js scripts are currently supported");
            return;
        }
        try {
            InputStream file;
            if (!f.exists()) {
                file = WorldEdit.class.getResourceAsStream("craftscripts/" + filename);
                if (file == null) {
                    player.printError("Script does not exist: " + filename);
                    return;
                }
            } else {
                file = new FileInputStream(f);
            }
            DataInputStream in = new DataInputStream(file);
            byte[] data = new byte[in.available()];
            in.readFully(data);
            in.close();
            script = new String(data, 0, data.length, "utf-8");
        }
        catch (IOException e) {
            player.printError("Script read error: " + e.getMessage());
            return;
        }
        LocalSession session = this.getSession(player);
        CraftScriptContext scriptContext = new CraftScriptContext(this, this.server, this.config, session, player, args);
        RhinoCraftScriptEngine engine = null;
        try {
            engine = new RhinoCraftScriptEngine();
        }
        catch (NoClassDefFoundError e) {
            player.printError("Failed to find an installed script engine.");
            player.printError("Please see http://wiki.sk89q.com/wiki/WorldEdit/Installation");
            return;
        }
        engine.setTimeLimit(this.config.scriptTimeout);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("argv", args);
        vars.put("context", scriptContext);
        vars.put("player", player);
        try {
            try {
                engine.evaluate(script, filename, vars);
            }
            catch (ScriptException e) {
                player.printError("Failed to execute:");
                player.printRaw(e.getMessage());
                e.printStackTrace();
                Object var14_15 = null;
                for (EditSession editSession : scriptContext.getEditSessions()) {
                    editSession.flushQueue();
                    session.remember(editSession);
                }
                return;
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (WorldEditException e) {
                throw e;
            }
            catch (Throwable e) {
                player.printError("Failed to execute (see console):");
                player.printRaw(e.getClass().getCanonicalName());
                e.printStackTrace();
                Object var14_16 = null;
                for (EditSession editSession : scriptContext.getEditSessions()) {
                    editSession.flushQueue();
                    session.remember(editSession);
                }
                return;
            }
            Object var14_14 = null;
            i$2 = scriptContext.getEditSessions().iterator();
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            Iterator<EditSession> i$2 = scriptContext.getEditSessions().iterator();
            while (true) {
                if (!i$2.hasNext()) {
                    throw throwable;
                }
                EditSession editSession = i$2.next();
                editSession.flushQueue();
                session.remember(editSession);
            }
        }
        while (i$2.hasNext()) {
            EditSession editSession = i$2.next();
            editSession.flushQueue();
            session.remember(editSession);
        }
    }

    public LocalConfiguration getConfiguration() {
        return this.config;
    }

    public ServerInterface getServer() {
        return this.server;
    }

    public static String getVersion() {
        if (version != null) {
            return version;
        }
        Package p = WorldEdit.class.getPackage();
        if (p == null) {
            p = Package.getPackage("com.sk89q.worldedit");
        }
        if (p == null) {
            version = "(unknown)";
        } else {
            version = p.getImplementationVersion();
            if (version == null) {
                version = "(unknown)";
            }
        }
        return version;
    }

    static {
        WorldEdit.getVersion();
    }
}

