/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LogFormat;
import com.sk89q.worldedit.snapshots.SnapshotRepository;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.util.config.Configuration;

public class BukkitConfiguration
extends LocalConfiguration {
    private Configuration config;
    private Logger logger;
    public boolean noOpPermissions = false;

    public BukkitConfiguration(Configuration config, Logger logger) {
        this.config = config;
        this.logger = logger;
    }

    public void load() {
        this.showFirstUseVersion = false;
        this.profile = this.config.getBoolean("debug", this.profile);
        this.wandItem = this.config.getInt("wand-item", this.wandItem);
        this.defaultChangeLimit = Math.max(-1, this.config.getInt("limits.max-blocks-changed.default", this.defaultChangeLimit));
        this.maxChangeLimit = Math.max(-1, this.config.getInt("limits.max-blocks-changed.maximum", this.maxChangeLimit));
        this.maxRadius = Math.max(-1, this.config.getInt("limits.max-radius", this.maxRadius));
        this.maxSuperPickaxeSize = Math.max(1, this.config.getInt("limits.max-super-pickaxe-size", this.maxSuperPickaxeSize));
        this.registerHelp = true;
        this.logCommands = this.config.getBoolean("logging.log-commands", this.logCommands);
        this.superPickaxeDrop = this.config.getBoolean("super-pickaxe.drop-items", this.superPickaxeDrop);
        this.superPickaxeManyDrop = this.config.getBoolean("super-pickaxe.many-drop-items", this.superPickaxeManyDrop);
        this.noDoubleSlash = this.config.getBoolean("no-double-slash", this.noDoubleSlash);
        this.useInventory = this.config.getBoolean("use-inventory.enable", this.useInventory);
        this.useInventoryOverride = this.config.getBoolean("use-inventory.allow-override", this.useInventoryOverride);
        this.maxBrushRadius = this.config.getInt("limits.max-brush-radius", this.maxBrushRadius);
        this.navigationWand = this.config.getInt("navigation-wand.item", this.navigationWand);
        this.navigationWandMaxDistance = this.config.getInt("navigation-wand.max-distance", this.navigationWandMaxDistance);
        this.scriptTimeout = this.config.getInt("scripting.timeout", this.scriptTimeout);
        this.scriptsDir = this.config.getString("scripting.dir", this.scriptsDir);
        this.saveDir = this.config.getString("saving.dir", this.saveDir);
        this.disallowedBlocks = new HashSet(this.config.getIntList("limits.disallowed-blocks", null));
        this.allowedDataCycleBlocks = new HashSet(this.config.getIntList("limits.allowed-data-cycle-blocks", null));
        this.noOpPermissions = this.config.getBoolean("no-op-permissions", false);
        LocalSession.MAX_HISTORY_SIZE = Math.max(0, this.config.getInt("history.size", 0));
        LocalSession.EXPIRATION_GRACE = this.config.getInt("history.expiration", 10) * 60 * 1000;
        String snapshotsDir = this.config.getString("snapshots.directory", "");
        this.snapshotRepo = !snapshotsDir.trim().equals("") ? new SnapshotRepository(snapshotsDir) : null;
        String type = this.config.getString("shell-save-type", "").trim();
        this.shellSaveType = type.equals("") ? null : type;
        String logFile = this.config.getString("logging.file", "");
        if (!logFile.equals("")) {
            try {
                FileHandler handler = new FileHandler(logFile, true);
                handler.setFormatter(new LogFormat());
                this.logger.addHandler(handler);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Could not use log file " + logFile + ": " + e.getMessage());
            }
        } else {
            for (Handler handler : this.logger.getHandlers()) {
                this.logger.removeHandler(handler);
            }
        }
    }
}

