/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldedit.commands.WorldEditCommands;

public class GeneralCommands {
    @Command(aliases={"/limit"}, usage="<limit>", desc="Modify block change limit", min=1, max=1)
    @CommandPermissions(value={"worldedit.limit"})
    public static void limit(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = we.getConfiguration();
        int limit = Math.max(-1, args.getInteger(0));
        if (!player.hasPermission("worldedit.limit.unrestricted") && config.maxChangeLimit > -1 && limit > config.maxChangeLimit) {
            player.printError("Your maximum allowable limit is " + config.maxChangeLimit + ".");
            return;
        }
        session.setBlockChangeLimit(limit);
        player.print("Block change limit set to " + limit + ".");
    }

    @Command(aliases={"toggleplace"}, usage="", desc="", min=0, max=0)
    public static void togglePlace(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (session.togglePlacementPosition()) {
            player.print("Now placing at pos #1.");
        } else {
            player.print("Now placing at the block you stand in.");
        }
    }

    @Command(aliases={"searchitem", "/l", "search"}, usage="<query>", flags="bi", desc="Search for an item", min=1, max=1)
    public static void searchItem(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        String query = args.getString(0).trim().toLowerCase();
        boolean blocksOnly = args.hasFlag('b');
        boolean itemsOnly = args.hasFlag('i');
        try {
            int id = Integer.parseInt(query);
            ItemType type = ItemType.fromID(id);
            if (type != null) {
                player.print("#" + type.getID() + " (" + type.getName() + ")");
            } else {
                player.printError("No item found by ID " + id);
            }
            return;
        }
        catch (NumberFormatException e) {
            if (query.length() <= 2) {
                player.printError("Enter a longer search string (len > 2).");
                return;
            }
            if (!blocksOnly && !itemsOnly) {
                player.print("Searching for: " + query);
            } else {
                if (blocksOnly && itemsOnly) {
                    player.printError("You cannot use both the 'b' and 'i' flags simultaneously.");
                    return;
                }
                if (blocksOnly) {
                    player.print("Searching for blocks: " + query);
                } else {
                    player.print("Searching for items: " + query);
                }
            }
            int found = 0;
            block2: for (ItemType type : ItemType.values()) {
                if (found >= 15) {
                    player.print("Too many results!");
                    break;
                }
                if (blocksOnly && type.getID() > 255 || itemsOnly && type.getID() <= 255) continue;
                for (String alias : type.getAliases()) {
                    if (!alias.contains(query)) continue;
                    player.print("#" + type.getID() + " (" + type.getName() + ")");
                    ++found;
                    continue block2;
                }
            }
            if (found == 0) {
                player.printError("No items found.");
            }
            return;
        }
    }

    @Command(aliases={"we", "worldedit"}, desc="WorldEdit commands")
    @NestedCommand(value={WorldEditCommands.class})
    public static void we(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
    }
}

