/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.dev;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.commands.ChunkCommands;
import com.sk89q.worldedit.commands.ClipboardCommands;
import com.sk89q.worldedit.commands.GeneralCommands;
import com.sk89q.worldedit.commands.GenerationCommands;
import com.sk89q.worldedit.commands.HistoryCommands;
import com.sk89q.worldedit.commands.NavigationCommands;
import com.sk89q.worldedit.commands.RegionCommands;
import com.sk89q.worldedit.commands.ScriptingCommands;
import com.sk89q.worldedit.commands.SelectionCommands;
import com.sk89q.worldedit.commands.SnapshotUtilCommands;
import com.sk89q.worldedit.commands.ToolCommands;
import com.sk89q.worldedit.commands.ToolUtilCommands;
import com.sk89q.worldedit.commands.UtilityCommands;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentationPrinter {
    public static void main(String[] args) throws IOException {
        File commandsDir = new File(args[0]);
        List<Class<?>> commandClasses = DocumentationPrinter.getCommandClasses(commandsDir);
        System.out.println("Writing permissions wiki table...");
        DocumentationPrinter.writePermissionsWikiTable(commandClasses);
        System.out.println("Writing Bukkit plugin.yml...");
        DocumentationPrinter.writeBukkitYAML(commandClasses);
        System.out.println("Done!");
    }

    private static List<Class<?>> getCommandClasses(File dir) {
        ArrayList classes = new ArrayList();
        classes.add(ChunkCommands.class);
        classes.add(ClipboardCommands.class);
        classes.add(GeneralCommands.class);
        classes.add(GenerationCommands.class);
        classes.add(HistoryCommands.class);
        classes.add(NavigationCommands.class);
        classes.add(RegionCommands.class);
        classes.add(ScriptingCommands.class);
        classes.add(SelectionCommands.class);
        classes.add(SnapshotUtilCommands.class);
        classes.add(ToolUtilCommands.class);
        classes.add(ToolCommands.class);
        classes.add(UtilityCommands.class);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writePermissionsWikiTable(List<Class<?>> commandClasses) throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream("wiki_permissions.txt");
            PrintStream print = new PrintStream(stream);
            DocumentationPrinter._writePermissionsWikiTable(print, commandClasses, "/");
            Object var4_3 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
        stream.close();
    }

    private static void _writePermissionsWikiTable(PrintStream stream, List<Class<?>> commandClasses, String prefix) {
        for (Class<?> cls : commandClasses) {
            for (Method method : cls.getMethods()) {
                if (!method.isAnnotationPresent(Command.class)) continue;
                Command cmd = method.getAnnotation(Command.class);
                stream.println("|-");
                stream.print("| " + prefix + cmd.aliases()[0]);
                stream.print(" || ");
                if (method.isAnnotationPresent(CommandPermissions.class)) {
                    CommandPermissions perms = method.getAnnotation(CommandPermissions.class);
                    String[] permKeys = perms.value();
                    for (int i = 0; i < permKeys.length; ++i) {
                        if (i > 0) {
                            stream.print(", ");
                        }
                        stream.print(permKeys[i]);
                    }
                }
                stream.println();
                if (!method.isAnnotationPresent(NestedCommand.class)) continue;
                NestedCommand nested = method.getAnnotation(NestedCommand.class);
                Class<?>[] nestedClasses = nested.value();
                DocumentationPrinter._writePermissionsWikiTable(stream, Arrays.asList(nestedClasses), prefix + cmd.aliases()[0] + " ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeBukkitYAML(List<Class<?>> commandClasses) throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream("plugin.yml");
            PrintStream print = new PrintStream(stream);
            DocumentationPrinter._writeBukkitYAML(print, commandClasses);
            Object var4_3 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
        stream.close();
    }

    private static void _writeBukkitYAML(PrintStream stream, List<Class<?>> commandClasses) {
        stream.println("name: WorldEdit");
        stream.println("main: com.sk89q.worldedit.bukkit.WorldEditPlugin");
        stream.println("version: \"WEVERSIONMACRO\"");
        stream.println("commands:");
        for (Class<?> cls : commandClasses) {
            for (Method method : cls.getMethods()) {
                if (!method.isAnnotationPresent(Command.class)) continue;
                Command cmd = method.getAnnotation(Command.class);
                stream.println("    " + cmd.aliases()[0] + ":");
                stream.println("        description: " + cmd.desc());
                stream.println("        usage: /<command> " + (cmd.flags().length() > 0 ? "[-" + cmd.flags() + "] " : "") + cmd.usage());
                if (cmd.aliases().length <= 1) continue;
                stream.println("        aliases: [" + StringUtil.joinQuotedString(cmd.aliases(), ", ", 1, "'") + "]");
            }
        }
    }
}

