/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.snapshots.SnapshotRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesConfiguration
extends LocalConfiguration {
    protected Properties properties;
    protected File path;

    public PropertiesConfiguration(File path) {
        this.path = path;
        this.properties = new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void load() {
        block30: {
            block29: {
                stream = null;
                try {
                    stream = new FileInputStream(this.path);
                    this.properties.load(stream);
                    var4_2 = null;
                    ** if (stream == null) goto lbl-1000
                }
                catch (Throwable var3_13) {
                    var4_3 = null;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw var3_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block29;
                    catch (FileNotFoundException e) {
                        var4_2 = null;
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {}
                        }
                        break block29;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        var4_2 = null;
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
            this.profile = this.getBool("profile", this.profile);
            this.disallowedBlocks = this.getIntSet("disallowed-blocks", PropertiesConfiguration.defaultDisallowedBlocks);
            this.defaultChangeLimit = this.getInt("default-max-changed-blocks", this.defaultChangeLimit);
            this.maxChangeLimit = this.getInt("max-changed-blocks", this.maxChangeLimit);
            this.shellSaveType = this.getString("shell-save-type", this.shellSaveType);
            this.maxRadius = this.getInt("max-radius", this.maxRadius);
            this.maxSuperPickaxeSize = this.getInt("max-super-pickaxe-size", this.maxSuperPickaxeSize);
            this.maxBrushRadius = this.getInt("max-brush-radius", this.maxBrushRadius);
            this.logCommands = this.getBool("log-commands", this.logCommands);
            this.registerHelp = this.getBool("register-help", this.registerHelp);
            this.wandItem = this.getInt("wand-item", this.wandItem);
            this.superPickaxeDrop = this.getBool("super-pickaxe-drop-items", this.superPickaxeDrop);
            this.superPickaxeManyDrop = this.getBool("super-pickaxe-many-drop-items", this.superPickaxeManyDrop);
            this.noDoubleSlash = this.getBool("no-double-slash", this.noDoubleSlash);
            this.useInventory = this.getBool("use-inventory", this.useInventory);
            this.useInventoryOverride = this.getBool("use-inventory-override", this.useInventoryOverride);
            this.navigationWand = this.getInt("nav-wand-item", this.navigationWand);
            this.navigationWandMaxDistance = this.getInt("nav-wand-distance", this.navigationWandMaxDistance);
            this.scriptTimeout = this.getInt("scripting-timeout", this.scriptTimeout);
            LocalSession.MAX_HISTORY_SIZE = Math.max(15, this.getInt("history-size", 15));
            snapshotsDir = this.getString("snapshots-dir", "");
            if (!snapshotsDir.isEmpty()) {
                this.snapshotRepo = new SnapshotRepository(snapshotsDir);
            }
            output = null;
            this.path.getParentFile().mkdirs();
            try {
                output = new FileOutputStream(this.path);
                this.properties.store(output, "Don't put comments; they get removed");
                var7_15 = null;
                ** if (output == null) goto lbl-1000
            }
            catch (Throwable var6_23) {
                var7_18 = null;
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var6_23;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block30;
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    var7_16 = null;
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException e) {}
                    }
                    break block30;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    var7_17 = null;
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }

    protected String getString(String key, String def) {
        String val;
        if (def == null) {
            def = "";
        }
        if ((val = this.properties.getProperty(key)) == null) {
            this.properties.setProperty(key, def);
            return def;
        }
        return val;
    }

    protected boolean getBool(String key, boolean def) {
        String val = this.properties.getProperty(key);
        if (val == null) {
            this.properties.setProperty(key, def ? "true" : "false");
            return def;
        }
        return val.equalsIgnoreCase("true") || val.equals("1");
    }

    protected int getInt(String key, int def) {
        String val = this.properties.getProperty(key);
        if (val == null) {
            this.properties.setProperty(key, String.valueOf(def));
            return def;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            this.properties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    protected double getDouble(String key, double def) {
        String val = this.properties.getProperty(key);
        if (val == null) {
            this.properties.setProperty(key, String.valueOf(def));
            return def;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            this.properties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    protected Set<Integer> getIntSet(String key, int[] def) {
        String[] parts;
        String val = this.properties.getProperty(key);
        if (val == null) {
            this.properties.setProperty(key, StringUtil.joinString(def, ",", 0));
            HashSet<Integer> set = new HashSet<Integer>();
            for (int i : def) {
                set.add(i);
            }
            return set;
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (String part : parts = val.split(",")) {
            try {
                int v = Integer.parseInt(part.trim());
                set.add(v);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return set;
    }
}

