/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.util.yaml;

import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLNode;
import com.sk89q.util.yaml.YAMLProcessorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;

public class YAMLProcessor
extends YAMLNode {
    private Yaml yaml;
    private File file;
    private String header = null;

    public YAMLProcessor(File file, boolean writeDefaults, YAMLFormat format) {
        super(new HashMap<String, Object>(), writeDefaults);
        DumperOptions options = new DumperOptions();
        options.setIndent(4);
        options.setDefaultFlowStyle(format.getStyle());
        Representer representer = new Representer();
        representer.setDefaultFlowStyle(format.getStyle());
        this.yaml = new Yaml((BaseConstructor)new SafeConstructor(), representer, options);
        this.file = file;
    }

    public YAMLProcessor(File file, boolean writeDefaults) {
        this(file, writeDefaults, YAMLFormat.COMPACT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() throws IOException {
        block11: {
            FileInputStream stream = null;
            stream = new FileInputStream(this.file);
            this.read(this.yaml.load((Reader)new UnicodeReader((InputStream)stream)));
            Object var4_2 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                break block11;
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (YAMLProcessorException e) {
                    this.root = new HashMap();
                    Object var4_3 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block11;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void setHeader(String ... headerLines) {
        StringBuilder header = new StringBuilder();
        for (String line : headerLines) {
            if (header.length() > 0) {
                header.append("\r\n");
            }
            header.append(line);
        }
        this.setHeader(header.toString());
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean save() {
        FileOutputStream stream = null;
        File parent = this.file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        stream = new FileOutputStream(this.file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
        if (this.header != null) {
            writer.append(this.header);
            writer.append("\r\n");
        }
        this.yaml.dump((Object)this.root, (Writer)writer);
        boolean bl = true;
        Object var6_6 = null;
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return bl;
        catch (IOException iOException) {
            try {
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return false;
    }

    private void read(Object input) throws YAMLProcessorException {
        try {
            this.root = null == input ? new HashMap() : (Map)input;
        }
        catch (ClassCastException e) {
            throw new YAMLProcessorException("Root document must be an key-value structure");
        }
    }

    public static YAMLNode getEmptyNode(boolean writeDefaults) {
        return new YAMLNode(new HashMap<String, Object>(), writeDefaults);
    }
}

