/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.PlayerNeededException;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.WorldEditPermissionException;
import java.io.File;

public abstract class LocalCommandSender {
    protected ServerInterface server;

    public LocalCommandSender(ServerInterface server) {
        this.server = server;
    }

    public abstract String getName();

    public abstract void printRaw(String var1);

    public abstract void printDebug(String var1);

    public abstract void print(String var1);

    public abstract void printError(String var1);

    public abstract String[] getGroups();

    public abstract boolean hasPermission(String var1);

    public void checkPermission(String permission) throws WorldEditPermissionException {
        if (!this.hasPermission(permission)) {
            throw new WorldEditPermissionException();
        }
    }

    public File openFileOpenDialog(String[] extensions) {
        this.printError("File dialogs are not supported in your environment.");
        return null;
    }

    public File openFileSaveDialog(String[] extensions) {
        this.printError("File dialogs are not supported in your environment.");
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LocalCommandSender)) {
            return false;
        }
        LocalCommandSender other2 = (LocalCommandSender)other;
        return other2.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public LocalPlayer asPlayer() throws PlayerNeededException {
        throw new PlayerNeededException();
    }
}

