/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EntityType;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.regions.Region;
import java.util.PriorityQueue;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalWorld {
    protected Random random = new Random();
    private final PriorityQueue<QueuedEffect> effectQueue = new PriorityQueue();
    private int taskId = -1;

    public abstract String getName();

    public abstract boolean setBlockType(Vector var1, int var2);

    public boolean setBlockTypeFast(Vector pt, int type) {
        return this.setBlockType(pt, type);
    }

    public abstract int getBlockType(Vector var1);

    public abstract void setBlockData(Vector var1, int var2);

    public abstract void setBlockDataFast(Vector var1, int var2);

    public boolean setTypeIdAndData(Vector pt, int type, int data) {
        boolean ret = this.setBlockType(pt, type);
        this.setBlockData(pt, data);
        return ret;
    }

    public boolean setTypeIdAndDataFast(Vector pt, int type, int data) {
        boolean ret = this.setBlockTypeFast(pt, type);
        this.setBlockDataFast(pt, data);
        return ret;
    }

    public abstract int getBlockData(Vector var1);

    public abstract int getBlockLightLevel(Vector var1);

    public abstract boolean regenerate(Region var1, EditSession var2);

    public abstract boolean copyToWorld(Vector var1, BaseBlock var2);

    public abstract boolean copyFromWorld(Vector var1, BaseBlock var2);

    public abstract boolean clearContainerBlockContents(Vector var1);

    public abstract boolean generateTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateBigTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateBirchTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateRedwoodTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateTallRedwoodTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public void dropItem(Vector pt, BaseItemStack item, int times) {
        for (int i = 0; i < times; ++i) {
            this.dropItem(pt, item);
        }
    }

    public abstract void dropItem(Vector var1, BaseItemStack var2);

    public void simulateBlockMine(Vector pt) {
        BaseItemStack stack = BlockType.getBlockDrop(this.getBlockType(pt), (short)this.getBlockData(pt));
        if (stack == null) {
            return;
        }
        int amount = stack.getAmount();
        if (amount > 1) {
            this.dropItem(pt, new BaseItemStack(stack.getType(), 1, stack.getDamage()), amount);
        } else {
            this.dropItem(pt, stack, amount);
        }
    }

    @Deprecated
    public int killMobs(Vector origin, int radius) {
        return this.killMobs(origin, radius, false);
    }

    @Deprecated
    public int killMobs(Vector origin, int radius, boolean killPets) {
        return this.killMobs(origin, (double)radius, killPets ? 1 : 0);
    }

    public int killMobs(Vector origin, double radius, int flags) {
        return this.killMobs(origin, (int)radius, (flags & 1) != 0);
    }

    public abstract int removeEntities(EntityType var1, Vector var2, int var3);

    public boolean isValidBlockType(int type) {
        return BlockType.fromID(type) != null;
    }

    public void checkLoadedChunk(Vector pt) {
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public int getMaxY() {
        return 127;
    }

    public void fixAfterFastMode(Iterable<BlockVector2D> chunks) {
    }

    public void fixLighting(Iterable<BlockVector2D> chunks) {
    }

    public boolean playEffect(Vector position, int type, int data) {
        return false;
    }

    public boolean queueBlockBreakEffect(ServerInterface server, Vector position, int blockId, double priority) {
        if (this.taskId == -1) {
            this.taskId = server.schedule(0L, 1L, new Runnable(){

                public void run() {
                    int max = Math.max(1, Math.min(30, LocalWorld.this.effectQueue.size() / 3));
                    for (int i = 0; i < max; ++i) {
                        if (LocalWorld.this.effectQueue.isEmpty()) {
                            return;
                        }
                        ((QueuedEffect)LocalWorld.this.effectQueue.poll()).play();
                    }
                }
            });
        }
        if (this.taskId == -1) {
            return false;
        }
        this.effectQueue.offer(new QueuedEffect(position, blockId, priority));
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueuedEffect
    implements Comparable<QueuedEffect> {
        private final Vector position;
        private final int blockId;
        private final double priority;

        public QueuedEffect(Vector position, int blockId, double priority) {
            this.position = position;
            this.blockId = blockId;
            this.priority = priority;
        }

        public void play() {
            LocalWorld.this.playEffect(this.position, 2001, this.blockId);
        }

        @Override
        public int compareTo(QueuedEffect other) {
            return Double.compare(this.priority, other.priority);
        }
    }

    public class KillFlags {
        public static final int PETS = 1;
        public static final int NPCS = 2;
        public static final int ANIMALS = 4;
    }
}

