/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class WorldEditPlayerListener
extends PlayerListener {
    private WorldEditPlugin plugin;
    private boolean ignoreLeftClickAir = false;

    public WorldEditPlayerListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
        plugin.registerEvent("PLAYER_QUIT", (Listener)this);
        plugin.registerEvent("PLAYER_INTERACT", (Listener)this);
        plugin.registerEvent("PLAYER_COMMAND_PREPROCESS", (Listener)this);
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getWorldEdit().markExpire(this.plugin.wrapPlayer(event.getPlayer()));
    }

    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        String[] split = event.getMessage().split(" ");
        if (this.plugin.getWorldEdit().handleCommand(this.plugin.wrapPlayer(event.getPlayer()), split)) {
            event.setCancelled(true);
        }
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        BukkitPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        LocalWorld world = ((LocalPlayer)player).getWorld();
        WorldEdit we = this.plugin.getWorldEdit();
        switch (event.getAction()) {
            case LEFT_CLICK_BLOCK: {
                int taskId;
                Block clickedBlock = event.getClickedBlock();
                WorldVector pos = new WorldVector(world, clickedBlock.getX(), clickedBlock.getY(), clickedBlock.getZ());
                if (we.handleBlockLeftClick(player, pos)) {
                    event.setCancelled(true);
                }
                if (we.handleArmSwing(player)) {
                    event.setCancelled(true);
                }
                if (this.ignoreLeftClickAir || (taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    public void run() {
                        WorldEditPlayerListener.this.ignoreLeftClickAir = false;
                    }
                }, 2L)) == -1) break;
                this.ignoreLeftClickAir = true;
                break;
            }
            case LEFT_CLICK_AIR: {
                if (this.ignoreLeftClickAir || !we.handleArmSwing(player)) break;
                event.setCancelled(true);
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                Block clickedBlock = event.getClickedBlock();
                WorldVector pos = new WorldVector(world, clickedBlock.getX(), clickedBlock.getY(), clickedBlock.getZ());
                if (we.handleBlockRightClick(player, pos)) {
                    event.setCancelled(true);
                }
                if (!we.handleRightClick(player)) break;
                event.setCancelled(true);
                break;
            }
            case RIGHT_CLICK_AIR: {
                if (!we.handleRightClick(player)) break;
                event.setCancelled(true);
            }
        }
    }
}

