/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.cui.CUIPointBasedRegion;
import com.sk89q.worldedit.cui.SelectionPointEvent;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CuboidRegionSelector
implements RegionSelector,
CUIPointBasedRegion {
    protected BlockVector pos1;
    protected BlockVector pos2;
    protected CuboidRegion region;

    public CuboidRegionSelector(LocalWorld world) {
        this.region = new CuboidRegion(world, new Vector(), new Vector());
    }

    public CuboidRegionSelector() {
        this((LocalWorld)null);
    }

    public CuboidRegionSelector(RegionSelector oldSelector) {
        this.region = new CuboidRegion(oldSelector.getIncompleteRegion().getWorld(), new Vector(), new Vector());
        if (oldSelector instanceof CuboidRegionSelector) {
            CuboidRegionSelector cuboidRegionSelector = (CuboidRegionSelector)oldSelector;
            this.pos1 = cuboidRegionSelector.pos1;
            this.pos2 = cuboidRegionSelector.pos2;
        } else {
            Region oldRegion;
            try {
                oldRegion = oldSelector.getRegion();
            }
            catch (IncompleteRegionException e) {
                return;
            }
            this.pos1 = oldRegion.getMinimumPoint().toBlockVector();
            this.pos2 = oldRegion.getMaximumPoint().toBlockVector();
        }
        this.region.setPos1(this.pos1);
        this.region.setPos2(this.pos2);
    }

    @Override
    public boolean selectPrimary(Vector pos) {
        if (pos.equals(this.pos1)) {
            return false;
        }
        this.pos1 = pos.toBlockVector();
        this.region.setPos1(this.pos1);
        return true;
    }

    @Override
    public boolean selectSecondary(Vector pos) {
        if (pos.equals(this.pos2)) {
            return false;
        }
        this.pos2 = pos.toBlockVector();
        this.region.setPos2(this.pos2);
        return true;
    }

    @Override
    public void explainPrimarySelection(LocalPlayer player, LocalSession session, Vector pos) {
        if (this.pos1 != null && this.pos2 != null) {
            player.print("First position set to " + this.pos1 + " (" + this.region.getArea() + ").");
        } else {
            player.print("First position set to " + this.pos1 + ".");
        }
        session.dispatchCUIEvent(player, new SelectionPointEvent(0, pos, this.getArea()));
    }

    @Override
    public void explainSecondarySelection(LocalPlayer player, LocalSession session, Vector pos) {
        if (this.pos1 != null && this.pos2 != null) {
            player.print("Second position set to " + this.pos2 + " (" + this.region.getArea() + ").");
        } else {
            player.print("Second position set to " + this.pos2 + ".");
        }
        session.dispatchCUIEvent(player, new SelectionPointEvent(1, pos, this.getArea()));
    }

    @Override
    public void explainRegionAdjust(LocalPlayer player, LocalSession session) {
        if (this.pos1 != null) {
            session.dispatchCUIEvent(player, new SelectionPointEvent(0, this.pos1, this.getArea()));
        }
        if (this.pos2 != null) {
            session.dispatchCUIEvent(player, new SelectionPointEvent(1, this.pos2, this.getArea()));
        }
    }

    @Override
    public BlockVector getPrimaryPosition() throws IncompleteRegionException {
        if (this.pos1 == null) {
            throw new IncompleteRegionException();
        }
        return this.pos1;
    }

    @Override
    public boolean isDefined() {
        return this.pos1 != null && this.pos2 != null;
    }

    @Override
    public CuboidRegion getRegion() throws IncompleteRegionException {
        if (this.pos1 == null || this.pos2 == null) {
            throw new IncompleteRegionException();
        }
        return this.region;
    }

    @Override
    public CuboidRegion getIncompleteRegion() {
        return this.region;
    }

    @Override
    public void learnChanges() {
        this.pos1 = this.region.getPos1().toBlockVector();
        this.pos2 = this.region.getPos2().toBlockVector();
    }

    @Override
    public void clear() {
        this.pos1 = null;
        this.pos2 = null;
    }

    @Override
    public String getTypeName() {
        return "cuboid";
    }

    @Override
    public List<String> getInformationLines() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.pos1 != null) {
            lines.add("Position 1: " + this.pos1);
        }
        if (this.pos2 != null) {
            lines.add("Position 2: " + this.pos2);
        }
        return lines;
    }

    @Override
    public String getTypeId() {
        return "cuboid";
    }

    @Override
    public void describeCUI(LocalPlayer player) {
        if (this.pos1 != null) {
            player.dispatchCUIEvent(new SelectionPointEvent(0, this.pos1, this.getArea()));
        }
        if (this.pos2 != null) {
            player.dispatchCUIEvent(new SelectionPointEvent(1, this.pos2, this.getArea()));
        }
    }

    @Override
    public int getArea() {
        if (this.pos1 == null) {
            return -1;
        }
        if (this.pos2 == null) {
            return -1;
        }
        return this.region.getArea();
    }
}

