/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.data.ChunkStore;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygonal2DRegion
implements Region {
    protected List<BlockVector2D> points;
    protected BlockVector min;
    protected BlockVector max;
    protected int minY;
    protected int maxY;
    protected boolean hasY = false;
    protected LocalWorld world;

    public Polygonal2DRegion() {
        this(null);
    }

    public Polygonal2DRegion(LocalWorld world) {
        this.points = new ArrayList<BlockVector2D>();
        this.minY = 0;
        this.maxY = 0;
        this.hasY = false;
        this.world = world;
        this.recalculate();
    }

    public Polygonal2DRegion(LocalWorld world, List<BlockVector2D> points, int minY, int maxY) {
        this.points = points;
        this.minY = minY;
        this.maxY = maxY;
        this.hasY = true;
        this.world = world;
        this.recalculate();
    }

    public List<BlockVector2D> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    protected void recalculate() {
        if (this.points.size() == 0) {
            this.min = new BlockVector(0, 0, 0);
            this.max = new BlockVector(0, 0, 0);
            return;
        }
        int minX = this.points.get(0).getBlockX();
        int minZ = this.points.get(0).getBlockZ();
        int maxX = this.points.get(0).getBlockX();
        int maxZ = this.points.get(0).getBlockZ();
        for (BlockVector2D v : this.points) {
            int x = v.getBlockX();
            int z = v.getBlockZ();
            if (x < minX) {
                minX = x;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        int oldMinY = this.minY;
        int oldMaxY = this.maxY;
        this.minY = Math.min(oldMinY, oldMaxY);
        this.maxY = Math.max(oldMinY, oldMaxY);
        this.minY = Math.min(Math.max(0, this.minY), this.world == null ? 127 : this.world.getMaxY());
        this.maxY = Math.min(Math.max(0, this.maxY), this.world == null ? 127 : this.world.getMaxY());
        this.min = new BlockVector(minX, this.minY, minZ);
        this.max = new BlockVector(maxX, this.maxY, maxZ);
    }

    public void addPoint(Vector2D pt) {
        this.points.add(pt.toBlockVector2D());
        this.recalculate();
    }

    public void addPoint(BlockVector2D pt) {
        this.points.add(pt);
        this.recalculate();
    }

    public void addPoint(Vector pt) {
        this.points.add(new BlockVector2D(pt.getBlockX(), pt.getBlockZ()));
        this.recalculate();
    }

    public void setMinimumY(int y) {
        this.hasY = true;
        this.minY = y;
        this.recalculate();
    }

    public void setMaximumY(int y) {
        this.hasY = true;
        this.maxY = y;
        this.recalculate();
    }

    @Override
    public Vector getMinimumPoint() {
        return this.min;
    }

    @Override
    public Vector getMaximumPoint() {
        return this.max;
    }

    @Override
    public int getArea() {
        double area = 0.0;
        int j = this.points.size() - 1;
        int i = 0;
        while (i < this.points.size()) {
            area += (double)((this.points.get(j).getBlockX() + this.points.get(i).getBlockX()) * (this.points.get(j).getBlockZ() - this.points.get(i).getBlockZ()));
            j = i++;
        }
        return (int)Math.floor(Math.abs(area * 0.5) * (double)(this.maxY - this.minY + 1));
    }

    @Override
    public int getWidth() {
        return this.max.getBlockX() - this.min.getBlockX();
    }

    @Override
    public int getHeight() {
        return this.max.getBlockY() - this.min.getBlockY();
    }

    @Override
    public int getLength() {
        return this.max.getBlockZ() - this.min.getBlockZ();
    }

    @Override
    public void expand(Vector change) throws RegionOperationException {
        if (change.getBlockX() != 0 || change.getBlockZ() != 0) {
            throw new RegionOperationException("Polygons can only be expanded vertically.");
        }
        int changeY = change.getBlockY();
        if (changeY > 0) {
            this.maxY += changeY;
        } else {
            this.minY += changeY;
        }
        this.recalculate();
    }

    @Override
    public void contract(Vector change) throws RegionOperationException {
        if (change.getBlockX() != 0 || change.getBlockZ() != 0) {
            throw new RegionOperationException("Polygons can only be contracted vertically.");
        }
        int changeY = change.getBlockY();
        if (changeY > 0) {
            this.minY += changeY;
        } else {
            this.maxY += changeY;
        }
        this.recalculate();
    }

    @Override
    public boolean contains(Vector pt) {
        return Polygonal2DRegion.contains(this.points, this.minY, this.maxY, pt);
    }

    public static boolean contains(List<BlockVector2D> points, int minY, int maxY, Vector pt) {
        if (points.size() < 3) {
            return false;
        }
        int targetX = pt.getBlockX();
        int targetY = pt.getBlockY();
        int targetZ = pt.getBlockZ();
        if (targetY < minY || targetY > maxY) {
            return false;
        }
        boolean inside = false;
        int npoints = points.size();
        int xOld = points.get(npoints - 1).getBlockX();
        int zOld = points.get(npoints - 1).getBlockZ();
        for (int i = 0; i < npoints; ++i) {
            int z2;
            int z1;
            int x2;
            int x1;
            int xNew = points.get(i).getBlockX();
            int zNew = points.get(i).getBlockZ();
            if (xNew == targetX && zNew == targetZ) {
                return true;
            }
            if (xNew > xOld) {
                x1 = xOld;
                x2 = xNew;
                z1 = zOld;
                z2 = zNew;
            } else {
                x1 = xNew;
                x2 = xOld;
                z1 = zNew;
                z2 = zOld;
            }
            if (x1 <= targetX && targetX <= x2) {
                long crossproduct = ((long)targetZ - (long)z1) * (long)(x2 - x1) - ((long)z2 - (long)z1) * (long)(targetX - x1);
                if (crossproduct == 0L) {
                    if (z1 <= targetZ == targetZ <= z2) {
                        return true;
                    }
                } else if (crossproduct < 0L && x1 != targetX) {
                    inside = !inside;
                }
            }
            xOld = xNew;
            zOld = zNew;
        }
        return inside;
    }

    @Override
    public Set<Vector2D> getChunks() {
        HashSet<Vector2D> chunks = new HashSet<Vector2D>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
            for (int y = min.getBlockY(); y <= max.getBlockY(); ++y) {
                for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
                    Vector pt = new Vector(x, y, z);
                    if (!this.contains(pt)) continue;
                    chunks.add(ChunkStore.toChunk(pt));
                }
            }
        }
        return chunks;
    }

    public int size() {
        return this.points.size();
    }

    public boolean expandY(int y) {
        if (!this.hasY) {
            this.minY = y;
            this.maxY = y;
            this.hasY = true;
            return true;
        }
        if (y < this.minY) {
            this.minY = y;
            return true;
        }
        if (y > this.maxY) {
            this.maxY = y;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<BlockVector> iterator() {
        return new Polygonal2DRegionIterator(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<BlockVector2D> pts = this.getPoints();
        Iterator<BlockVector2D> it = pts.iterator();
        while (it.hasNext()) {
            BlockVector2D current = it.next();
            sb.append("(" + current.getBlockX() + ", " + current.getBlockZ() + ")");
            if (!it.hasNext()) continue;
            sb.append(" - ");
        }
        sb.append(" * (" + this.minY + " - " + this.maxY + ")");
        return sb.toString();
    }

    @Override
    public LocalWorld getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(LocalWorld world) {
        this.world = world;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Polygonal2DRegionIterator
    implements Iterator<BlockVector> {
        protected List<BlockVector2D> points = new ArrayList<BlockVector2D>();
        protected int minX;
        protected int minY;
        protected int minZ;
        protected int maxX;
        protected int maxY;
        protected int maxZ;
        protected int n;
        protected int i;
        protected int curX;
        protected int curZ;
        protected int curY;
        protected BlockVector next;

        public Polygonal2DRegionIterator(Polygonal2DRegion region) {
            this.points = new ArrayList<BlockVector2D>(region.points);
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            this.minX = min.getBlockX();
            this.minY = min.getBlockY();
            this.minZ = min.getBlockZ();
            this.maxX = max.getBlockX();
            this.maxY = max.getBlockY();
            this.maxZ = max.getBlockZ();
            this.n = (this.maxX - this.minX + 1) * (this.maxZ - this.minZ + 1);
            this.i = 0;
            this.curX = 0;
            this.curZ = 0;
            this.curY = this.minY;
            this.next = null;
            this.findNext();
        }

        private void findNext() {
            if (this.i >= this.n) {
                this.next = null;
                return;
            }
            if (this.next != null && this.curY <= this.maxY) {
                ++this.curY;
                this.next = new BlockVector(this.curX, this.curY, this.curZ);
                if (this.curY > this.maxY) {
                    ++this.i;
                    this.curY = this.minY;
                } else {
                    return;
                }
            }
            while (this.i < this.n) {
                this.curZ = this.i / (this.maxX - this.minX + 1) + this.minZ;
                this.curX = this.i % (this.maxX - this.minX + 1) + this.minX;
                BlockVector pt = new BlockVector(this.curX, this.minY, this.curZ);
                if (Polygonal2DRegion.contains(this.points, this.minY, this.maxY, pt)) {
                    this.next = pt;
                    return;
                }
                ++this.i;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public BlockVector next() {
            BlockVector next = this.next;
            this.findNext();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

