/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.cui.CUIPointBasedRegion;
import com.sk89q.worldedit.cui.SelectionMinMaxEvent;
import com.sk89q.worldedit.cui.SelectionPoint2DEvent;
import com.sk89q.worldedit.cui.SelectionShapeEvent;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.RegionSelector;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygonal2DRegionSelector
implements RegionSelector,
CUIPointBasedRegion {
    protected BlockVector pos1;
    protected Polygonal2DRegion region;

    public Polygonal2DRegionSelector(LocalWorld world) {
        this.region = new Polygonal2DRegion(world);
    }

    @Override
    public boolean selectPrimary(Vector pos) {
        if (pos.equals(this.pos1)) {
            return false;
        }
        this.pos1 = pos.toBlockVector();
        this.region = new Polygonal2DRegion(this.region.getWorld());
        this.region.addPoint(pos);
        this.region.expandY(pos.getBlockY());
        return true;
    }

    @Override
    public boolean selectSecondary(Vector pos) {
        if (this.region.size() > 0) {
            List<BlockVector2D> points = this.region.getPoints();
            BlockVector2D lastPoint = points.get(this.region.size() - 1);
            if (lastPoint.getBlockX() == pos.getBlockX() && lastPoint.getBlockZ() == pos.getBlockZ()) {
                return false;
            }
            if (points.size() >= 20) {
                return false;
            }
        }
        this.region.addPoint(pos);
        this.region.expandY(pos.getBlockY());
        return true;
    }

    @Override
    public void explainPrimarySelection(LocalPlayer player, LocalSession session, Vector pos) {
        player.print("Starting a new polygon at " + pos + ".");
        session.dispatchCUIEvent(player, new SelectionShapeEvent(this.getTypeId()));
        session.dispatchCUIEvent(player, new SelectionPoint2DEvent(0, pos, this.getArea()));
        session.dispatchCUIEvent(player, new SelectionMinMaxEvent(this.region.minY, this.region.maxY));
    }

    @Override
    public void explainSecondarySelection(LocalPlayer player, LocalSession session, Vector pos) {
        player.print("Added point #" + this.region.size() + " at " + pos + ".");
        session.dispatchCUIEvent(player, new SelectionPoint2DEvent(this.region.size() - 1, pos, this.getArea()));
        session.dispatchCUIEvent(player, new SelectionMinMaxEvent(this.region.minY, this.region.maxY));
    }

    @Override
    public void explainRegionAdjust(LocalPlayer player, LocalSession session) {
        session.dispatchCUIEvent(player, new SelectionMinMaxEvent(this.region.minY, this.region.maxY));
    }

    @Override
    public BlockVector getPrimaryPosition() throws IncompleteRegionException {
        if (this.pos1 == null) {
            throw new IncompleteRegionException();
        }
        return this.pos1;
    }

    @Override
    public Polygonal2DRegion getRegion() throws IncompleteRegionException {
        if (!this.isDefined()) {
            throw new IncompleteRegionException();
        }
        return this.region;
    }

    @Override
    public Polygonal2DRegion getIncompleteRegion() {
        return this.region;
    }

    @Override
    public boolean isDefined() {
        return this.region.size() > 2;
    }

    @Override
    public void learnChanges() {
        BlockVector2D pt = this.region.getPoints().get(0);
        this.pos1 = new BlockVector(pt.getBlockX(), this.region.getMinimumPoint().getBlockY(), pt.getBlockZ());
    }

    @Override
    public void clear() {
        this.pos1 = null;
        this.region = new Polygonal2DRegion(this.region.getWorld());
    }

    @Override
    public String getTypeName() {
        return "2Dx1D polygon";
    }

    @Override
    public List<String> getInformationLines() {
        return Collections.singletonList("# points: " + this.region.size());
    }

    @Override
    public String getTypeId() {
        return "polygon2d";
    }

    @Override
    public int getArea() {
        return this.region.getArea();
    }

    public int getPointCount() {
        return this.region.getPoints().size();
    }

    @Override
    public void describeCUI(LocalPlayer player) {
        List<BlockVector2D> points = this.region.getPoints();
        for (int id = 0; id < points.size(); ++id) {
            player.dispatchCUIEvent(new SelectionPoint2DEvent(id, points.get(id), this.getArea()));
        }
        player.dispatchCUIEvent(new SelectionMinMaxEvent(this.region.minY, this.region.maxY));
    }
}

