/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.util;

import com.sk89q.bukkit.util.DynamicPluginCommand;
import com.sk89q.bukkit.util.FallbackRegistrationListener;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRegistration {
    private final Plugin plugin;
    private final CommandExecutor executor;
    private CommandMap fallbackCommands;

    public CommandRegistration(Plugin plugin) {
        this(plugin, (CommandExecutor)plugin);
    }

    public CommandRegistration(Plugin plugin, CommandExecutor executor) {
        this.plugin = plugin;
        this.executor = executor;
    }

    public boolean registerAll(List<Command> registered) {
        CommandMap commandMap = this.getCommandMap();
        if (registered == null || commandMap == null) {
            return false;
        }
        for (Command command : registered) {
            commandMap.register(this.plugin.getDescription().getName(), (org.bukkit.command.Command)new DynamicPluginCommand(command.aliases(), command.desc(), "/" + command.aliases()[0] + " " + command.usage(), this.executor));
        }
        return true;
    }

    public CommandMap getCommandMap() {
        CommandMap commandMap = (CommandMap)ReflectionUtil.getField(this.plugin.getServer().getPluginManager(), "commandMap");
        if (commandMap == null) {
            if (this.fallbackCommands != null) {
                commandMap = this.fallbackCommands;
            } else {
                Bukkit.getServer().getLogger().severe(this.plugin.getDescription().getName() + ": Could not retrieve server CommandMap, using fallback instead! Please report to http://redmine.sk89q.com");
                this.fallbackCommands = commandMap = new SimpleCommandMap(Bukkit.getServer());
                Bukkit.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_COMMAND_PREPROCESS, (Listener)new FallbackRegistrationListener(this.fallbackCommands), Event.Priority.Normal, this.plugin);
            }
        }
        return commandMap;
    }

    public boolean unregisterCommands() {
        CommandMap commandMap = this.getCommandMap();
        ArrayList<String> toRemove = new ArrayList<String>();
        Map knownCommands = (Map)ReflectionUtil.getField(commandMap, "knownCommands");
        Set aliases = (Set)ReflectionUtil.getField(commandMap, "aliases");
        if (knownCommands == null || aliases == null) {
            return false;
        }
        Iterator i = knownCommands.values().iterator();
        while (i.hasNext()) {
            org.bukkit.command.Command cmd = (org.bukkit.command.Command)i.next();
            if (!(cmd instanceof DynamicPluginCommand) || !((DynamicPluginCommand)cmd).getOwner().equals(this.plugin)) continue;
            i.remove();
            for (String alias : cmd.getAliases()) {
                org.bukkit.command.Command aliasCmd = (org.bukkit.command.Command)knownCommands.get(alias);
                if (!cmd.equals(aliasCmd)) continue;
                aliases.remove(alias);
                toRemove.add(alias);
            }
        }
        for (String string : toRemove) {
            knownCommands.remove(string);
        }
        return true;
    }
}

