/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.PlayerDirection;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditPermissionException;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.WorldVectorFace;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.cui.CUIEvent;
import com.sk89q.worldedit.util.TargetBlock;
import java.io.File;

public abstract class LocalPlayer {
    protected ServerInterface server;

    protected LocalPlayer(ServerInterface server) {
        this.server = server;
    }

    public boolean isHoldingPickAxe() {
        int item = this.getItemInHand();
        return item == 257 || item == 270 || item == 274 || item == 278 || item == 285;
    }

    public void findFreePosition(WorldVector searchPos) {
        int y;
        LocalWorld world = searchPos.getWorld();
        int x = searchPos.getBlockX();
        int origY = y = Math.max(0, searchPos.getBlockY());
        int z = searchPos.getBlockZ();
        int free = 0;
        while (y <= 129) {
            free = BlockType.canPassThrough(world.getBlockType(new Vector(x, y, z))) ? (int)((byte)(free + 1)) : 0;
            if (free == 2) {
                if (y - 1 != origY) {
                    this.setPosition(new Vector((double)x + 0.5, (double)(y - 1), (double)z + 0.5));
                }
                return;
            }
            ++y;
        }
    }

    public void setOnGround(WorldVector searchPos) {
        LocalWorld world = searchPos.getWorld();
        int x = searchPos.getBlockX();
        int z = searchPos.getBlockZ();
        for (int y = Math.max(0, searchPos.getBlockY()); y >= 0; --y) {
            if (BlockType.canPassThrough(world.getBlockType(new Vector(x, y, z)))) continue;
            this.setPosition(new Vector((double)x + 0.5, (double)(y + 1), (double)z + 0.5));
            return;
        }
    }

    public void findFreePosition() {
        this.findFreePosition(this.getBlockIn());
    }

    public boolean ascendLevel() {
        WorldVector pos = this.getBlockIn();
        int x = pos.getBlockX();
        int z = pos.getBlockZ();
        LocalWorld world = this.getPosition().getWorld();
        int free = 0;
        int spots = 0;
        for (int y = Math.max(0, pos.getBlockY()); y <= 129; ++y) {
            free = BlockType.canPassThrough(world.getBlockType(new Vector(x, y, z))) ? (int)((byte)(free + 1)) : 0;
            if (free != 2 || (spots = (int)((byte)(spots + 1))) != 2) continue;
            int type = world.getBlockType(new Vector(x, y - 2, z));
            if (type == 10 || type == 11) {
                return false;
            }
            this.setPosition(new Vector((double)x + 0.5, (double)(y - 1), (double)z + 0.5));
            return true;
        }
        return false;
    }

    public boolean descendLevel() {
        WorldVector pos = this.getBlockIn();
        int x = pos.getBlockX();
        int z = pos.getBlockZ();
        LocalWorld world = this.getPosition().getWorld();
        int free = 0;
        for (int y = Math.max(0, pos.getBlockY() - 1); y >= 1; --y) {
            free = BlockType.canPassThrough(world.getBlockType(new Vector(x, y, z))) ? (int)((byte)(free + 1)) : 0;
            if (free != 2) continue;
            while (y >= 0) {
                int type = world.getBlockType(new Vector(x, y, z));
                if (type != 0 && type != 10 && type != 11) {
                    this.setPosition(new Vector((double)x + 0.5, (double)(y + 1), (double)z + 0.5));
                    return true;
                }
                --y;
            }
            return false;
        }
        return false;
    }

    public boolean ascendToCeiling(int clearance) {
        int y;
        WorldVector pos = this.getBlockIn();
        int x = pos.getBlockX();
        int initialY = Math.max(0, pos.getBlockY());
        int z = pos.getBlockZ();
        LocalWorld world = this.getPosition().getWorld();
        if (world.getBlockType(new Vector(x, y, z)) != 0) {
            return false;
        }
        for (y = Math.max(0, pos.getBlockY() + 2); y <= world.getMaxY(); ++y) {
            if (BlockType.canPassThrough(world.getBlockType(new Vector(x, y, z)))) continue;
            int platformY = Math.max(initialY, y - 3 - clearance);
            world.setBlockType(new Vector(x, platformY, z), 20);
            this.setPosition(new Vector((double)x + 0.5, (double)(platformY + 1), (double)z + 0.5));
            return true;
        }
        return false;
    }

    public boolean ascendUpwards(int distance) {
        WorldVector pos = this.getBlockIn();
        int x = pos.getBlockX();
        int initialY = Math.max(0, pos.getBlockY());
        int z = pos.getBlockZ();
        int maxY = Math.min(this.getWorld().getMaxY() + 1, initialY + distance);
        LocalWorld world = this.getPosition().getWorld();
        for (int y = Math.max(0, pos.getBlockY() + 1); y <= 129 && BlockType.canPassThrough(world.getBlockType(new Vector(x, y, z))) && y <= maxY + 1; ++y) {
            if (y != maxY + 1) continue;
            world.setBlockType(new Vector(x, y - 2, z), 20);
            this.setPosition(new Vector((double)x + 0.5, (double)(y - 1), (double)z + 0.5));
            return true;
        }
        return false;
    }

    public WorldVector getBlockIn() {
        WorldVector pos = this.getPosition();
        return WorldVector.toBlockPoint(pos.getWorld(), pos.getX(), pos.getY(), pos.getZ());
    }

    public WorldVector getBlockOn() {
        WorldVector pos = this.getPosition();
        return WorldVector.toBlockPoint(pos.getWorld(), pos.getX(), pos.getY() - 1.0, pos.getZ());
    }

    public WorldVector getBlockTrace(int range, boolean useLastBlock) {
        TargetBlock tb = new TargetBlock(this, range, 0.2);
        return useLastBlock ? tb.getAnyTargetBlock() : tb.getTargetBlock();
    }

    public WorldVectorFace getBlockTraceFace(int range, boolean useLastBlock) {
        TargetBlock tb = new TargetBlock(this, range, 0.2);
        return useLastBlock ? tb.getAnyTargetBlockFace() : tb.getTargetBlockFace();
    }

    public WorldVector getBlockTrace(int range) {
        return this.getBlockTrace(range, false);
    }

    public WorldVector getSolidBlockTrace(int range) {
        TargetBlock tb = new TargetBlock(this, range, 0.2);
        return tb.getSolidTargetBlock();
    }

    public PlayerDirection getCardinalDirection() {
        return this.getCardinalDirection(0);
    }

    public PlayerDirection getCardinalDirection(int yawOffset) {
        if (this.getPitch() > 67.5) {
            return PlayerDirection.DOWN;
        }
        if (this.getPitch() < -67.5) {
            return PlayerDirection.UP;
        }
        double rot = (this.getYaw() + (double)yawOffset - 90.0) % 360.0;
        if (rot < 0.0) {
            rot += 360.0;
        }
        return LocalPlayer.getDirection(rot);
    }

    private static PlayerDirection getDirection(double rot) {
        if (0.0 <= rot && rot < 22.5) {
            return PlayerDirection.NORTH;
        }
        if (22.5 <= rot && rot < 67.5) {
            return PlayerDirection.NORTH_EAST;
        }
        if (67.5 <= rot && rot < 112.5) {
            return PlayerDirection.EAST;
        }
        if (112.5 <= rot && rot < 157.5) {
            return PlayerDirection.SOUTH_EAST;
        }
        if (157.5 <= rot && rot < 202.5) {
            return PlayerDirection.SOUTH;
        }
        if (202.5 <= rot && rot < 247.5) {
            return PlayerDirection.SOUTH_WEST;
        }
        if (247.5 <= rot && rot < 292.5) {
            return PlayerDirection.WEST;
        }
        if (292.5 <= rot && rot < 337.5) {
            return PlayerDirection.NORTH_WEST;
        }
        if (337.5 <= rot && rot < 360.0) {
            return PlayerDirection.NORTH;
        }
        return null;
    }

    public abstract int getItemInHand();

    public abstract String getName();

    public abstract WorldVector getPosition();

    public abstract LocalWorld getWorld();

    public abstract double getPitch();

    public abstract double getYaw();

    public abstract void giveItem(int var1, int var2);

    public boolean passThroughForwardWall(int range) {
        BlockWorldVector block;
        int searchDist = 0;
        TargetBlock hitBlox = new TargetBlock(this, range, 0.2);
        LocalWorld world = this.getPosition().getWorld();
        boolean firstBlock = true;
        int freeToFind = 2;
        boolean inFree = false;
        while ((block = hitBlox.getNextBlock()) != null) {
            boolean free = BlockType.canPassThrough(world.getBlockType(block));
            if (firstBlock) {
                firstBlock = false;
                if (!free) {
                    --freeToFind;
                    continue;
                }
            }
            if (++searchDist > 20) {
                return false;
            }
            if (inFree != free && free) {
                --freeToFind;
            }
            if (freeToFind == 0) {
                this.setOnGround(block);
                return true;
            }
            inFree = free;
        }
        return false;
    }

    public abstract void printRaw(String var1);

    public abstract void printDebug(String var1);

    public abstract void print(String var1);

    public abstract void printError(String var1);

    public abstract void setPosition(Vector var1, float var2, float var3);

    public void setPosition(Vector pos) {
        this.setPosition(pos, (float)this.getPitch(), (float)this.getYaw());
    }

    public abstract String[] getGroups();

    public abstract BlockBag getInventoryBlockBag();

    public abstract boolean hasPermission(String var1);

    public File openFileOpenDialog(String[] extensions) {
        this.printError("File dialogs are not supported in your environment.");
        return null;
    }

    public File openFileSaveDialog(String[] extensions) {
        this.printError("File dialogs are not supported in your environment.");
        return null;
    }

    public boolean canDestroyBedrock() {
        return this.hasPermission("worldedit.override.bedrock");
    }

    public void dispatchCUIEvent(CUIEvent event) {
    }

    public void dispatchCUIHandshake() {
    }

    public boolean equals(Object other) {
        if (!(other instanceof LocalPlayer)) {
            return false;
        }
        LocalPlayer other2 = (LocalPlayer)other;
        return other2.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void checkPermission(String permission) throws WorldEditPermissionException {
        if (!this.hasPermission(permission)) {
            throw new WorldEditPermissionException();
        }
    }

    public boolean isPlayer() {
        return true;
    }
}

