/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class WorldEditPlayerListener
extends PlayerListener {
    private WorldEditPlugin plugin;
    private boolean ignoreLeftClickAir = false;
    private static final Pattern cuipattern = Pattern.compile("u00a74u00a75u00a73u00a74([^|]*)\\|?(.*)");

    public WorldEditPlayerListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
        plugin.registerEvent("PLAYER_QUIT", (Listener)this);
        plugin.registerEvent("PLAYER_INTERACT", (Listener)this);
        plugin.registerEvent("PLAYER_COMMAND_PREPROCESS", (Listener)this, Event.Priority.Low);
        plugin.registerEvent("PLAYER_CHAT", (Listener)this);
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getWorldEdit().markExpire(this.plugin.wrapPlayer(event.getPlayer()));
    }

    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        String[] split = event.getMessage().split(" ");
        if (split.length > 0) {
            split = this.plugin.getWorldEdit().commandDetection(split);
            split[0] = "/" + split[0];
        }
        event.setMessage(StringUtil.joinString(split, " "));
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        BukkitPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        LocalWorld world = ((LocalPlayer)player).getWorld();
        WorldEdit we = this.plugin.getWorldEdit();
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_BLOCK) {
            int taskId;
            Block clickedBlock = event.getClickedBlock();
            WorldVector pos = new WorldVector(world, clickedBlock.getX(), clickedBlock.getY(), clickedBlock.getZ());
            if (we.handleBlockLeftClick(player, pos)) {
                event.setCancelled(true);
            }
            if (we.handleArmSwing(player)) {
                event.setCancelled(true);
            }
            if (!this.ignoreLeftClickAir && (taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                public void run() {
                    WorldEditPlayerListener.this.ignoreLeftClickAir = false;
                }
            }, 2L)) != -1) {
                this.ignoreLeftClickAir = true;
            }
        } else if (action == Action.LEFT_CLICK_AIR) {
            if (this.ignoreLeftClickAir) {
                return;
            }
            if (we.handleArmSwing(player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.RIGHT_CLICK_BLOCK) {
            Block clickedBlock = event.getClickedBlock();
            WorldVector pos = new WorldVector(world, clickedBlock.getX(), clickedBlock.getY(), clickedBlock.getZ());
            if (we.handleBlockRightClick(player, pos)) {
                event.setCancelled(true);
            }
            if (we.handleRightClick(player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.RIGHT_CLICK_AIR && we.handleRightClick(player)) {
            event.setCancelled(true);
        }
    }

    public void onPlayerChat(PlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Matcher matcher = cuipattern.matcher(event.getMessage());
        if (matcher.find()) {
            String type = matcher.group(1);
            String args = matcher.group(2);
            if (type.equals("v")) {
                try {
                    this.plugin.getSession(event.getPlayer()).setCUIVersion(Integer.parseInt(args));
                    event.setCancelled(true);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }
}

