/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.regions.Region;
import java.io.File;
import java.io.IOException;

public class ClipboardCommands {
    private final WorldEdit we;

    public ClipboardCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"/copy"}, usage="", desc="Copy the selection to the clipboard", min=0, max=0)
    @CommandPermissions(value={"worldedit.clipboard.copy"})
    public void copy(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        Vector pos = session.getPlacementPosition(player);
        CuboidClipboard clipboard = new CuboidClipboard(max.subtract(min).add(new Vector(1, 1, 1)), min, min.subtract(pos));
        clipboard.copy(editSession);
        session.setClipboard(clipboard);
        player.print("Block(s) copied.");
    }

    @Command(aliases={"/cut"}, usage="[leave-id]", desc="Cut the selection to the clipboard", min=0, max=1)
    @CommandPermissions(value={"worldedit.clipboard.cut"})
    @Logging(value=Logging.LogMode.REGION)
    public void cut(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        BaseBlock block = new BaseBlock(0);
        if (args.argsLength() > 0) {
            block = this.we.getBlock(player, args.getString(0));
        }
        Region region = session.getSelection(player.getWorld());
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        Vector pos = session.getPlacementPosition(player);
        CuboidClipboard clipboard = new CuboidClipboard(max.subtract(min).add(new Vector(1, 1, 1)), min, min.subtract(pos));
        clipboard.copy(editSession);
        session.setClipboard(clipboard);
        editSession.setBlocks(session.getSelection(player.getWorld()), block);
        player.print("Block(s) cut.");
    }

    @Command(aliases={"/paste"}, usage="", flags="ao", desc="Paste the clipboard's contents", help="Pastes the clipboard's contents.\nFlags:\n  -a skips air blocks\n  -o pastes at the original position", min=0, max=0)
    @CommandPermissions(value={"worldedit.clipboard.paste"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void paste(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        boolean atOrigin = args.hasFlag('o');
        boolean pasteNoAir = args.hasFlag('a');
        if (atOrigin) {
            Vector pos = session.getClipboard().getOrigin();
            session.getClipboard().place(editSession, pos, pasteNoAir);
            player.findFreePosition();
            player.print("Pasted to copy origin. Undo with //undo");
        } else {
            Vector pos = session.getPlacementPosition(player);
            session.getClipboard().paste(editSession, pos, pasteNoAir);
            player.findFreePosition();
            player.print("Pasted relative to you. Undo with //undo");
        }
    }

    @Command(aliases={"/rotate"}, usage="<angle-in-degrees>", desc="Rotate the contents of the clipboard", min=1, max=1)
    @CommandPermissions(value={"worldedit.clipboard.rotate"})
    public void rotate(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int angle = args.getInteger(0);
        if (angle % 90 == 0) {
            CuboidClipboard clipboard = session.getClipboard();
            clipboard.rotate2D(angle);
            player.print("Clipboard rotated by " + angle + " degrees.");
        } else {
            player.printError("Angles must be divisible by 90 degrees.");
        }
    }

    @Command(aliases={"/flip"}, usage="[dir]", flags="p", desc="Flip the contents of the clipboard.", help="Flips the contents of the clipboard.\nThe -p flag flips the selection around the player,\ninstead of the selections center.", min=0, max=1)
    @CommandPermissions(value={"worldedit.clipboard.flip"})
    public void flip(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        CuboidClipboard.FlipDirection dir = this.we.getFlipDirection(player, args.argsLength() > 0 ? args.getString(0).toLowerCase() : "me");
        CuboidClipboard clipboard = session.getClipboard();
        clipboard.flip(dir, args.hasFlag('p'));
        player.print("Clipboard flipped.");
    }

    @Command(aliases={"/load"}, usage="<filename>", desc="Load a schematic into your clipboard", min=1, max=1)
    @CommandPermissions(value={"worldedit.clipboard.load"})
    public void load(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        String filename = args.getString(0);
        File dir = this.we.getWorkingDirectoryFile(config.saveDir);
        File f = this.we.getSafeOpenFile(player, dir, filename, "schematic", "schematic");
        try {
            String filePath = f.getCanonicalPath();
            String dirPath = dir.getCanonicalPath();
            if (!filePath.substring(0, dirPath.length()).equals(dirPath)) {
                player.printError("Schematic could not read or it does not exist.");
            } else {
                session.setClipboard(CuboidClipboard.loadSchematic(f));
                WorldEdit.logger.info(player.getName() + " loaded " + filePath);
                player.print(filename + " loaded. Paste it with //paste");
            }
        }
        catch (DataException e) {
            player.printError("Load error: " + e.getMessage());
        }
        catch (IOException e) {
            player.printError("Schematic could not read or it does not exist: " + e.getMessage());
        }
    }

    @Command(aliases={"/save"}, usage="<filename>", desc="Save a schematic into your clipboard", min=1, max=1)
    @CommandPermissions(value={"worldedit.clipboard.save"})
    public void save(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        String filename = args.getString(0);
        File dir = this.we.getWorkingDirectoryFile(config.saveDir);
        File f = this.we.getSafeSaveFile(player, dir, filename, "schematic", "schematic");
        if (!dir.exists() && !dir.mkdir()) {
            player.printError("The storage folder could not be created.");
            return;
        }
        try {
            File parent = f.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            session.getClipboard().saveSchematic(f);
            WorldEdit.logger.info(player.getName() + " saved " + f.getCanonicalPath());
            player.print(filename + " saved.");
        }
        catch (DataException se) {
            player.printError("Save error: " + se.getMessage());
        }
        catch (IOException e) {
            player.printError("Schematic could not written: " + e.getMessage());
        }
    }

    @Command(aliases={"clearclipboard"}, usage="", desc="Clear your clipboard", min=0, max=0)
    @CommandPermissions(value={"worldedit.clipboard.clear"})
    public void clearClipboard(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setClipboard(null);
        player.print("Clipboard cleared.");
    }
}

