/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIterator;
import com.sk89q.worldedit.regions.RegionOperationException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegion
implements Region {
    protected LocalWorld world;

    public AbstractRegion(LocalWorld world) {
        this.world = world;
    }

    @Override
    public Iterator<BlockVector> iterator() {
        return new RegionIterator(this);
    }

    @Override
    public LocalWorld getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(LocalWorld world) {
        this.world = world;
    }

    @Override
    public void expand(Vector ... changes) throws RegionOperationException {
        for (Vector change : changes) {
            this.expand(change);
        }
    }

    @Override
    public void contract(Vector ... changes) throws RegionOperationException {
        for (Vector change : changes) {
            this.contract(change);
        }
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        this.expand(change);
        this.contract(change);
    }
}

