/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.data.ChunkStore;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.RegionOperationException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CylinderRegion
extends AbstractRegion {
    private Vector center;
    private Vector2D center2D;
    private Vector2D radius;
    private int minY;
    private int maxY;
    private boolean hasY = false;

    public CylinderRegion() {
        this((LocalWorld)null);
    }

    public CylinderRegion(LocalWorld world) {
        this(world, new Vector(), new Vector2D(), 0, 0);
        this.hasY = false;
    }

    public CylinderRegion(LocalWorld world, Vector center, Vector2D radius, int minY, int maxY) {
        super(world);
        this.center = center;
        this.setRadius(radius);
        this.minY = minY;
        this.maxY = maxY;
        this.hasY = true;
    }

    public CylinderRegion(CylinderRegion region) {
        this(region.world, region.center, region.getRadius(), region.minY, region.maxY);
        this.hasY = region.hasY;
    }

    public Vector getCenter() {
        return this.center;
    }

    public void setCenter(Vector center) {
        this.center = center;
        this.center2D = center.toVector2D();
    }

    public Vector2D getRadius() {
        return this.radius.subtract(0.5, 0.5);
    }

    public void setRadius(Vector2D radius) {
        this.radius = radius.add(0.5, 0.5);
    }

    public void extendRadius(Vector2D minRadius) {
        this.setRadius(Vector2D.getMaximum(minRadius, this.getRadius()));
    }

    public void setMinimumY(int y) {
        this.hasY = true;
        this.minY = y;
    }

    public void setMaximumY(int y) {
        this.hasY = true;
        this.maxY = y;
    }

    @Override
    public Vector getMinimumPoint() {
        return this.center2D.subtract(this.getRadius()).toVector(this.minY);
    }

    @Override
    public Vector getMaximumPoint() {
        return this.center2D.add(this.getRadius()).toVector(this.maxY);
    }

    public int getMaximumY() {
        return this.maxY;
    }

    public int getMinimumY() {
        return this.minY;
    }

    @Override
    public int getArea() {
        return (int)Math.floor(this.radius.getX() * this.radius.getZ() * Math.PI * (double)this.getHeight());
    }

    @Override
    public int getWidth() {
        return (int)(2.0 * this.radius.getX());
    }

    @Override
    public int getHeight() {
        return this.maxY - this.minY + 1;
    }

    @Override
    public int getLength() {
        return (int)(2.0 * this.radius.getZ());
    }

    @Override
    public void expand(Vector change) throws RegionOperationException {
        if (change.getBlockX() != 0 || change.getBlockZ() != 0) {
            throw new RegionOperationException("Cylinders can only be expanded vertically.");
        }
        int changeY = change.getBlockY();
        if (changeY > 0) {
            this.maxY += changeY;
        } else {
            this.minY += changeY;
        }
    }

    @Override
    public void contract(Vector change) throws RegionOperationException {
        if (change.getBlockX() != 0 || change.getBlockZ() != 0) {
            throw new RegionOperationException("Cylinders can only be expanded vertically.");
        }
        int changeY = change.getBlockY();
        if (changeY > 0) {
            this.minY += changeY;
        } else {
            this.maxY += changeY;
        }
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        this.setCenter(this.getCenter().add(change));
        int changeY = change.getBlockY();
        this.maxY += changeY;
        this.minY += changeY;
    }

    @Override
    public boolean contains(Vector pt) {
        int blockY = pt.getBlockY();
        if (blockY < this.minY || blockY > this.maxY) {
            return false;
        }
        return pt.toVector2D().subtract(this.center2D).divide(this.radius).lengthSq() <= 1.0;
    }

    @Override
    public Set<Vector2D> getChunks() {
        HashSet<Vector2D> chunks = new HashSet<Vector2D>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
            for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
                Vector pt = new Vector(x, this.minY, z);
                if (!this.contains(pt)) continue;
                chunks.add(ChunkStore.toChunk(pt));
            }
        }
        return chunks;
    }

    public boolean setY(int y) {
        if (!this.hasY) {
            this.minY = y;
            this.maxY = y;
            this.hasY = true;
            return true;
        }
        if (y < this.minY) {
            this.minY = y;
            return true;
        }
        if (y > this.maxY) {
            this.maxY = y;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.center + " - " + this.radius;
    }
}

