/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.cui.CUIEvent;
import com.sk89q.worldedit.spout.SpoutPlayerBlockBag;
import com.sk89q.worldedit.spout.SpoutUtil;
import com.sk89q.worldedit.spout.WorldEditPlugin;
import org.spout.api.geo.discrete.Point;
import org.spout.api.geo.discrete.Pointm;
import org.spout.api.geo.discrete.Transform;
import org.spout.api.inventory.ItemStack;
import org.spout.api.material.MaterialData;
import org.spout.api.math.Quaternion;
import org.spout.api.math.Vector3;
import org.spout.api.player.Player;

public class SpoutPlayer
extends LocalPlayer {
    private Player player;
    private WorldEditPlugin plugin;

    public SpoutPlayer(WorldEditPlugin plugin, ServerInterface server, Player player) {
        super(server);
        this.plugin = plugin;
        this.player = player;
    }

    public int getItemInHand() {
        ItemStack itemStack = this.player.getEntity().getInventory().getCurrentItem();
        return itemStack != null ? (int)itemStack.getMaterial().getId() : 0;
    }

    public String getName() {
        return this.player.getName();
    }

    public WorldVector getPosition() {
        Pointm loc = this.player.getEntity().getTransform().getPosition();
        return new WorldVector(SpoutUtil.getLocalWorld(loc.getWorld()), loc.getX(), loc.getY(), loc.getZ());
    }

    public double getPitch() {
        return this.player.getEntity().getTransform().getRotation().getAxisAngles().getY();
    }

    public double getYaw() {
        return this.player.getEntity().getTransform().getRotation().getAxisAngles().getZ();
    }

    public void giveItem(int type, int amt) {
        this.player.getEntity().getInventory().addItem(new ItemStack(MaterialData.getMaterial((short)((short)type)), amt));
    }

    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(part);
        }
    }

    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7d" + part);
        }
    }

    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a77" + part);
        }
    }

    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7c" + part);
        }
    }

    public void setPosition(Vector pos, float pitch, float yaw) {
        Transform t = this.player.getEntity().getTransform();
        t.setPosition(new Point(t.getPosition().getWorld(), (float)pos.getX(), (float)pos.getY(), (float)pos.getZ()));
        t.setRotation(new Quaternion(pitch, Vector3.UNIT_Z).rotate(yaw, Vector3.UNIT_Y));
    }

    public String[] getGroups() {
        return this.player.getGroups();
    }

    public BlockBag getInventoryBlockBag() {
        return new SpoutPlayerBlockBag(this.player);
    }

    public boolean hasPermission(String perm) {
        return this.player.hasPermission(perm);
    }

    public LocalWorld getWorld() {
        return SpoutUtil.getLocalWorld(this.player.getEntity().getTransform().getPosition().getWorld());
    }

    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        if (params.length > 0) {
            this.player.sendRawMessage("\u00a75\u00a76\u00a74\u00a75" + event.getTypeId() + "|" + StringUtil.joinString(params, "|"));
        } else {
            this.player.sendRawMessage("\u00a75\u00a76\u00a74\u00a75" + event.getTypeId());
        }
    }

    public void dispatchCUIHandshake() {
        this.player.sendRawMessage("\u00a75\u00a76\u00a74\u00a75");
    }

    public Player getPlayer() {
        return this.player;
    }
}

