/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.OutOfBlocksException;
import com.sk89q.worldedit.bags.OutOfSpaceException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.ItemType;
import org.spout.api.inventory.Inventory;
import org.spout.api.inventory.ItemStack;
import org.spout.api.material.MaterialData;
import org.spout.api.player.Player;

public class SpoutPlayerBlockBag
extends BlockBag {
    private Player player;
    private ItemStack[] items;

    public SpoutPlayerBlockBag(Player player) {
        this.player = player;
    }

    private void loadInventory() {
        if (this.items == null) {
            this.items = this.player.getEntity().getInventory().getContents();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void fetchItem(BaseItem item) throws BlockBagException {
        int amount;
        int id = item.getType();
        short damage = item.getDamage();
        int n = amount = item instanceof BaseItemStack ? ((BaseItemStack)item).getAmount() : 1;
        assert (amount == 1);
        boolean usesDamageValue = ItemType.usesDamageValue(id);
        if (id == 0) {
            throw new IllegalArgumentException("Can't fetch air block");
        }
        this.loadInventory();
        boolean found = false;
        for (int slot = 0; slot < this.items.length; ++slot) {
            ItemStack bukkitItem = this.items[slot];
            if (bukkitItem == null || bukkitItem.getMaterial().getId() != id || usesDamageValue && bukkitItem.getDamage() != damage) continue;
            int currentAmount = bukkitItem.getAmount();
            if (currentAmount < 0) {
                return;
            }
            if (currentAmount > 1) {
                bukkitItem.setAmount(currentAmount - 1);
                found = true;
                break;
            }
            this.items[slot] = null;
            found = true;
            break;
        }
        if (!found) {
            throw new OutOfBlocksException();
        }
    }

    public void storeItem(BaseItem item) throws BlockBagException {
        int amount;
        int id = item.getType();
        short damage = item.getDamage();
        int n = amount = item instanceof BaseItemStack ? ((BaseItemStack)item).getAmount() : 1;
        assert (amount <= 64);
        boolean usesDamageValue = ItemType.usesDamageValue(id);
        if (id == 0) {
            throw new IllegalArgumentException("Can't store air block");
        }
        this.loadInventory();
        int freeSlot = -1;
        for (int slot = 0; slot < this.items.length; ++slot) {
            ItemStack bukkitItem = this.items[slot];
            if (bukkitItem == null) {
                if (freeSlot != -1) continue;
                freeSlot = slot;
                continue;
            }
            if (bukkitItem.getMaterial().getId() != id || usesDamageValue && bukkitItem.getDamage() != damage) continue;
            int currentAmount = bukkitItem.getAmount();
            if (currentAmount < 0) {
                return;
            }
            if (currentAmount >= 64) continue;
            int spaceLeft = 64 - currentAmount;
            if (spaceLeft >= amount) {
                bukkitItem.setAmount(currentAmount + amount);
                return;
            }
            bukkitItem.setAmount(64);
            amount -= spaceLeft;
        }
        if (freeSlot > -1) {
            this.items[freeSlot] = new ItemStack(MaterialData.getMaterial((short)((short)id)), amount);
            return;
        }
        throw new OutOfSpaceException(id);
    }

    public void flushChanges() {
        if (this.items != null) {
            Inventory inv = this.player.getEntity().getInventory();
            for (int i = 0; i < this.items.length && i < this.player.getEntity().getInventorySize(); ++i) {
                inv.setItem(this.items[i], i);
            }
            this.items = null;
        }
    }

    public void addSourcePosition(Vector pos) {
    }

    public void addSingleSourcePosition(Vector pos) {
    }
}

