/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.spout.SpoutRawCommandExecutor;
import com.sk89q.worldedit.spout.SpoutUtil;
import com.sk89q.worldedit.spout.WorldEditPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spout.api.Game;
import org.spout.api.Spout;
import org.spout.api.command.RawCommandExecutor;
import org.spout.api.geo.World;
import org.spout.api.material.Material;
import org.spout.api.material.MaterialData;
import org.spout.api.plugin.Plugin;
import org.spout.api.util.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpoutServerInterface
extends ServerInterface {
    public Game game;
    public WorldEditPlugin plugin;
    private final SpoutRawCommandExecutor executor;

    public SpoutServerInterface(WorldEditPlugin plugin, Game game) {
        this.plugin = plugin;
        this.game = game;
        this.executor = new SpoutRawCommandExecutor(plugin);
    }

    @Override
    public int resolveItem(String name) {
        Material mat = MaterialData.getMaterial((String)name);
        return mat == null ? (short)0 : mat.getId();
    }

    @Override
    public boolean isValidMobType(String type) {
        return false;
    }

    @Override
    public void reload() {
        this.plugin.loadConfiguration();
    }

    @Override
    public int schedule(long delay, long period, Runnable task) {
        return this.game.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, task, delay, period);
    }

    @Override
    public List<LocalWorld> getWorlds() {
        Collection worlds = this.game.getWorlds();
        ArrayList<LocalWorld> ret = new ArrayList<LocalWorld>(worlds.size());
        for (World world : worlds) {
            ret.add(SpoutUtil.getLocalWorld(world));
        }
        return ret;
    }

    @Override
    public void onCommandRegistration(List<Command> commands) {
        for (Command command : commands) {
            Spout.getGame().getRootCommand().addSubCommand((Named)this.plugin, command.aliases()[0]).addAlias(command.aliases()).setRawExecutor((RawCommandExecutor)this.executor).closeSubCommand();
        }
    }
}

