/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EntityType;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.regions.Region;
import org.spout.api.geo.World;
import org.spout.api.material.MaterialData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpoutWorld
extends LocalWorld {
    private World world;

    public SpoutWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public String getName() {
        return this.world.getName();
    }

    @Override
    public boolean setBlockType(Vector pt, int type) {
        this.world.setBlockId(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ(), (short)type);
        return this.world.getBlockId(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()) != type;
    }

    @Override
    public boolean setBlockTypeFast(Vector pt, int type) {
        return this.setBlockType(pt, type);
    }

    @Override
    public boolean setTypeIdAndData(Vector pt, int type, int data) {
        int origType = this.getBlockType(pt);
        int origData = this.getBlockData(pt);
        this.world.setBlockIdAndData(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ(), (short)type, (short)data);
        return origType != type && origData != data;
    }

    @Override
    public boolean setTypeIdAndDataFast(Vector pt, int type, int data) {
        return this.setTypeIdAndData(pt, type, data);
    }

    @Override
    public int getBlockType(Vector pt) {
        return this.world.getBlockId(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
    }

    @Override
    public void setBlockData(Vector pt, int data) {
        this.setTypeIdAndData(pt, this.world.getBlockId(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()), data);
    }

    @Override
    public void setBlockDataFast(Vector pt, int data) {
        this.setBlockData(pt, data);
    }

    @Override
    public int getBlockData(Vector pt) {
        return this.world.getBlockData(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
    }

    @Override
    public int getBlockLightLevel(Vector pt) {
        return this.world.getBlockMaterial(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).getLightLevel();
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        return false;
    }

    @Override
    public boolean copyToWorld(Vector pt, BaseBlock block) {
        return false;
    }

    @Override
    public boolean copyFromWorld(Vector pt, BaseBlock block) {
        return false;
    }

    @Override
    public boolean clearContainerBlockContents(Vector pt) {
        return false;
    }

    @Override
    public boolean generateTree(EditSession editSession, Vector pt) {
        return false;
    }

    @Override
    public boolean generateBigTree(EditSession editSession, Vector pt) {
        return false;
    }

    @Override
    public boolean generateBirchTree(EditSession editSession, Vector pt) {
        return false;
    }

    @Override
    public boolean generateRedwoodTree(EditSession editSession, Vector pt) {
        return false;
    }

    @Override
    public boolean generateTallRedwoodTree(EditSession editSession, Vector pt) {
        return false;
    }

    @Override
    public void dropItem(Vector pt, BaseItemStack item) {
    }

    @Override
    public int killMobs(Vector origin, double radius, int flags) {
        int num = 0;
        return num;
    }

    @Override
    public int removeEntities(EntityType type, Vector origin, int radius) {
        int num = 0;
        return num;
    }

    @Override
    public boolean isValidBlockType(int type) {
        return MaterialData.getBlock((short)((short)type)) != null;
    }

    @Override
    public void checkLoadedChunk(Vector pt) {
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SpoutWorld)) {
            return false;
        }
        return ((SpoutWorld)other).world.equals(this.world);
    }

    @Override
    public int hashCode() {
        return this.world.hashCode();
    }

    @Override
    public int getMaxY() {
        return this.world.getHeight() - 1;
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2D> chunks) {
    }

    @Override
    public boolean playEffect(Vector position, int type, int data) {
        return false;
    }
}

