/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.spout.SpoutPlayer;
import com.sk89q.worldedit.spout.WorldEditPlugin;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spout.api.Spout;
import org.spout.api.event.EventHandler;
import org.spout.api.event.Listener;
import org.spout.api.event.Order;
import org.spout.api.event.player.PlayerChatEvent;
import org.spout.api.event.player.PlayerInteractEvent;
import org.spout.api.event.player.PlayerJoinEvent;
import org.spout.api.event.player.PlayerLeaveEvent;
import org.spout.api.event.server.PreCommandEvent;
import org.spout.api.geo.discrete.Point;
import org.spout.api.plugin.Plugin;

public class WorldEditPlayerListener
implements Listener {
    private WorldEditPlugin plugin;
    private boolean ignoreLeftClickAir = false;
    private static final Pattern cuipattern = Pattern.compile("u00a74u00a75u00a73u00a74([^|]*)\\|?(.*)");

    public WorldEditPlayerListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(event=PlayerJoinEvent.class, order=Order.EARLIEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.plugin.wrapPlayer(event.getPlayer()).dispatchCUIHandshake();
    }

    @EventHandler(event=PlayerLeaveEvent.class)
    public void onPlayerQuit(PlayerLeaveEvent event) {
        this.plugin.getWorldEdit().markExpire(this.plugin.wrapPlayer(event.getPlayer()));
    }

    public void onPlayerCommandPreprocess(PreCommandEvent event) {
        String[] split = event.getMessage().split(" ");
        if (split.length > 0) {
            split[0] = "/" + split[0];
            split = this.plugin.getWorldEdit().commandDetection(split);
            event.setMessage(StringUtil.joinString(split, " "));
        }
    }

    @EventHandler(event=PlayerInteractEvent.class)
    public void onPlayerInteract(PlayerInteractEvent event) {
        SpoutPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        LocalWorld world = ((LocalPlayer)player).getWorld();
        WorldEdit we = this.plugin.getWorldEdit();
        PlayerInteractEvent.Action action = event.getAction();
        if (action == PlayerInteractEvent.Action.LEFT_CLICK) {
            int taskId;
            Point clickedBlock;
            WorldVector pos;
            if (event.isAir() && this.ignoreLeftClickAir) {
                return;
            }
            if (!event.isAir() && we.handleBlockLeftClick(player, pos = new WorldVector(world, (clickedBlock = event.getInteractedPoint()).getX(), clickedBlock.getY(), clickedBlock.getZ()))) {
                event.setCancelled(true);
            }
            if (we.handleArmSwing(player)) {
                event.setCancelled(true);
            }
            if (!event.isAir() && !this.ignoreLeftClickAir && (taskId = Spout.getGame().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                public void run() {
                    WorldEditPlayerListener.this.ignoreLeftClickAir = false;
                }
            }, 2L)) != -1) {
                this.ignoreLeftClickAir = true;
            }
        } else if (action == PlayerInteractEvent.Action.RIGHT_CLICK) {
            Point clickedBlock;
            WorldVector pos;
            if (!event.isAir() && we.handleBlockRightClick(player, pos = new WorldVector(world, (clickedBlock = event.getInteractedPoint()).getX(), clickedBlock.getY(), clickedBlock.getZ()))) {
                event.setCancelled(true);
            }
            if (we.handleRightClick(player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(event=PlayerChatEvent.class)
    public void onPlayerChat(PlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Matcher matcher = cuipattern.matcher(event.getMessage());
        if (matcher.find()) {
            String type = matcher.group(1);
            String args = matcher.group(2);
            if (type.equals("v")) {
                try {
                    this.plugin.getSession(event.getPlayer()).setCUIVersion(Integer.parseInt(args));
                    event.setCancelled(true);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }
}

