/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.util;

import com.sk89q.bukkit.util.DynamicPluginCommand;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.wepif.WEPIFRuntimeException;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.HelpTopicFactory;

public class DynamicPluginCommandHelpTopic
extends HelpTopic {
    private final DynamicPluginCommand cmd;

    public DynamicPluginCommandHelpTopic(DynamicPluginCommand cmd) {
        this.cmd = cmd;
        this.name = "/" + cmd.getName();
        if (cmd.getRegisteredWith() instanceof CommandsManager) {
            String lookupName;
            Map<String, String> helpText = ((CommandsManager)cmd.getRegisteredWith()).getHelpMessages();
            if (helpText.containsKey(lookupName = cmd.getName().replaceAll("/", ""))) {
                this.fullText = helpText.get(lookupName);
            }
            if ((helpText = ((CommandsManager)cmd.getRegisteredWith()).getCommands()).containsKey(cmd.getName())) {
                String shortText = helpText.get(cmd.getName());
                if (this.fullText == null) {
                    this.fullText = this.name + " " + shortText;
                }
                this.shortText = shortText;
            }
        } else {
            this.shortText = cmd.getDescription();
        }
    }

    public boolean canSee(CommandSender player) {
        if (this.cmd.getPermissions() != null && this.cmd.getPermissions().length > 0) {
            if (this.cmd.getRegisteredWith() instanceof CommandsManager) {
                try {
                    for (String perm : this.cmd.getPermissions()) {
                        if (!((CommandsManager)this.cmd.getRegisteredWith()).hasPermission(player, perm)) continue;
                        return true;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (player instanceof OfflinePlayer) {
                try {
                    for (String perm : this.cmd.getPermissions()) {
                        if (!PermissionsResolverManager.getInstance().hasPermission((OfflinePlayer)player, perm)) continue;
                        return true;
                    }
                }
                catch (WEPIFRuntimeException e) {
                    // empty catch block
                }
            }
            for (String perm : this.cmd.getPermissions()) {
                if (!player.hasPermission(perm)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String getFullText(CommandSender forWho) {
        if (this.fullText == null || this.fullText.length() == 0) {
            return this.getShortText();
        }
        return this.fullText;
    }

    public static class Factory
    implements HelpTopicFactory<DynamicPluginCommand> {
        public HelpTopic createTopic(DynamicPluginCommand command) {
            return new DynamicPluginCommandHelpTopic(command);
        }
    }
}

