/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.blocks.BlockData;

public class BaseBlock {
    private short type = 0;
    private byte data = 0;

    public BaseBlock(int type) {
        this(type, 0);
    }

    public BaseBlock(int type, int data) {
        this.type = (short)type;
        this.data = (byte)data;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = (short)type;
    }

    public int getData() {
        return this.data;
    }

    public void setData(int data) {
        this.data = (byte)data;
    }

    public boolean isAir() {
        return this.type == 0;
    }

    public int rotate90() {
        int newData = BlockData.rotate90(this.type, this.data);
        this.data = (byte)newData;
        return this.data;
    }

    public int rotate90Reverse() {
        int newData = BlockData.rotate90Reverse(this.type, this.data);
        this.data = (byte)newData;
        return newData;
    }

    public int cycleData(int increment) {
        int newData = BlockData.cycle(this.type, this.data, increment);
        this.data = (byte)newData;
        return newData;
    }

    public BaseBlock flip() {
        this.data = (byte)BlockData.flip(this.type, this.data);
        return this;
    }

    public BaseBlock flip(CuboidClipboard.FlipDirection direction) {
        this.data = (byte)BlockData.flip(this.type, this.data, direction);
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BaseBlock)) {
            return false;
        }
        return this.type == ((BaseBlock)o).type && this.data == ((BaseBlock)o).data;
    }

    public boolean equalsFuzzy(BaseBlock o) {
        return this.type == o.type && this.data == o.data || this.data == -1 || o.data == -1;
    }

    public int hashCode() {
        int ret = this.type << 3;
        if (this.data != -1) {
            ret |= this.data;
        }
        return ret;
    }

    public String toString() {
        return "BaseBlock id: " + this.getType() + " with damage: " + this.getData();
    }

    @Deprecated
    public boolean inIterable(Iterable<BaseBlock> iter) {
        for (BaseBlock block : iter) {
            if (!block.equalsFuzzy(this)) continue;
            return true;
        }
        return false;
    }
}

