/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.data.DataException;
import java.util.HashMap;
import java.util.Map;

public class NoteBlock
extends BaseBlock
implements TileEntityBlock {
    private byte note;

    public NoteBlock() {
        super(25);
        this.note = 0;
    }

    public NoteBlock(int data) {
        super(25, data);
        this.note = 0;
    }

    public NoteBlock(int data, byte note) {
        super(25, data);
        this.note = note;
    }

    public byte getNote() {
        return this.note;
    }

    public void setNote(byte note) {
        this.note = note;
    }

    @Override
    public String getTileEntityID() {
        return "Music";
    }

    @Override
    public Map<String, Tag> toTileEntityNBT() throws DataException {
        HashMap<String, Tag> values = new HashMap<String, Tag>();
        values.put("note", new ByteTag("note", this.note));
        return values;
    }

    @Override
    public void fromTileEntityNBT(Map<String, Tag> values) throws DataException {
        if (values == null) {
            return;
        }
        Tag t = values.get("id");
        if (!(t instanceof StringTag) || !((StringTag)t).getValue().equals("Music")) {
            throw new DataException("'Music' tile entity expected");
        }
        t = values.get("note");
        if (t instanceof ByteTag) {
            this.note = ((ByteTag)t).getValue();
        }
    }
}

