/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.data;

import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.ChestBlock;
import com.sk89q.worldedit.blocks.DispenserBlock;
import com.sk89q.worldedit.blocks.FurnaceBlock;
import com.sk89q.worldedit.blocks.MobSpawnerBlock;
import com.sk89q.worldedit.blocks.NoteBlock;
import com.sk89q.worldedit.blocks.SignBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.data.Chunk;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.data.InvalidFormatException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OldChunk
implements Chunk {
    private CompoundTag rootTag;
    private byte[] blocks;
    private byte[] data;
    private int rootX;
    private int rootZ;
    private Map<BlockVector, Map<String, Tag>> tileEntities;
    private LocalWorld world;

    public OldChunk(LocalWorld world, CompoundTag tag) throws DataException {
        this.rootTag = tag;
        this.world = world;
        this.blocks = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "Blocks", ByteArrayTag.class).getValue();
        this.data = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "Data", ByteArrayTag.class).getValue();
        this.rootX = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "xPos", IntTag.class).getValue();
        this.rootZ = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "zPos", IntTag.class).getValue();
        int size = 32768;
        if (this.blocks.length != size) {
            throw new InvalidFormatException("Chunk blocks byte array expected to be " + size + " bytes; found " + this.blocks.length);
        }
        if (this.data.length != size / 2) {
            throw new InvalidFormatException("Chunk block data byte array expected to be " + size + " bytes; found " + this.data.length);
        }
    }

    @Override
    public int getBlockID(Vector pos) throws DataException {
        if (pos.getBlockY() >= 128) {
            return 0;
        }
        int x = pos.getBlockX() - this.rootX * 16;
        int y = pos.getBlockY();
        int z = pos.getBlockZ() - this.rootZ * 16;
        int index = y + (z * 128 + x * 128 * 16);
        try {
            return this.blocks[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataException("Chunk does not contain position " + pos);
        }
    }

    @Override
    public int getBlockData(Vector pos) throws DataException {
        int z;
        if (pos.getBlockY() >= 128) {
            return 0;
        }
        int x = pos.getBlockX() - this.rootX * 16;
        int y = pos.getBlockY();
        int index = y + ((z = pos.getBlockZ() - this.rootZ * 16) * 128 + x * 128 * 16);
        boolean shift = index % 2 == 0;
        index /= 2;
        try {
            if (!shift) {
                return (this.data[index] & 0xF0) >> 4;
            }
            return this.data[index] & 0xF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataException("Chunk does not contain position " + pos);
        }
    }

    private void populateTileEntities() throws DataException {
        Object tags = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "TileEntities", ListTag.class).getValue();
        this.tileEntities = new HashMap<BlockVector, Map<String, Tag>>();
        Iterator i$ = tags.iterator();
        while (i$.hasNext()) {
            Tag tag = (Tag)i$.next();
            if (!(tag instanceof CompoundTag)) {
                throw new InvalidFormatException("CompoundTag expected in TileEntities");
            }
            CompoundTag t = (CompoundTag)tag;
            int x = 0;
            int y = 0;
            int z = 0;
            HashMap values = new HashMap();
            for (Map.Entry entry : t.getValue().entrySet()) {
                if (((String)entry.getKey()).equals("x")) {
                    if (entry.getValue() instanceof IntTag) {
                        x = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("y")) {
                    if (entry.getValue() instanceof IntTag) {
                        y = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("z") && entry.getValue() instanceof IntTag) {
                    z = ((IntTag)entry.getValue()).getValue();
                }
                values.put(entry.getKey(), entry.getValue());
            }
            BlockVector vec = new BlockVector(x, y, z);
            this.tileEntities.put(vec, values);
        }
    }

    private Map<String, Tag> getBlockTileEntity(Vector pos) throws DataException {
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        return this.tileEntities.get(new BlockVector(pos));
    }

    @Override
    public BaseBlock getBlock(Vector pos) throws DataException {
        int id = this.getBlockID(pos);
        int data = this.getBlockData(pos);
        BaseBlock block = id == 68 || id == 63 ? new SignBlock(id, data) : (id == 54 ? new ChestBlock(data) : (id == 61 || id == 62 ? new FurnaceBlock(id, data) : (id == 23 ? new DispenserBlock(data) : (id == 52 ? new MobSpawnerBlock(data) : (id == 25 ? new NoteBlock(data) : new BaseBlock(id, data))))));
        if (block instanceof TileEntityBlock) {
            Map<String, Tag> tileEntity = this.getBlockTileEntity(pos);
            ((TileEntityBlock)((Object)block)).fromTileEntityNBT(tileEntity);
        }
        return block;
    }
}

