/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Console;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.io.IOException;

public class SchematicCommands {
    private final WorldEdit we;

    public SchematicCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"load", "l"}, usage="[format] <filename>", desc="Load a schematic into your clipboard", help="Load a schematic into your clipboard\nFormat is a format from \"//schematic formats\"\nIf the format is not provided, WorldEdit will\nattempt to automatically detect the format of the schematic", flags="f", min=1, max=2)
    @CommandPermissions(value={"worldedit.clipboard.load", "worldedit.schematic.load"})
    public void load(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        SchematicFormat format;
        String fileName;
        String formatName;
        LocalConfiguration config = this.we.getConfiguration();
        if (args.argsLength() == 1) {
            formatName = null;
            fileName = args.getString(0);
        } else {
            formatName = args.getString(0);
            fileName = args.getString(1);
        }
        File dir = this.we.getWorkingDirectoryFile(config.saveDir);
        File f = this.we.getSafeOpenFile(player, dir, fileName, "schematic", "schematic");
        if (!f.exists()) {
            player.printError("Schemtic " + fileName + " does not exist!");
            return;
        }
        SchematicFormat schematicFormat = format = formatName == null ? null : SchematicFormat.getFormat(formatName);
        if (format == null) {
            format = SchematicFormat.getFormat(f);
        }
        if (format == null) {
            player.printError("Unknown schematic format: " + formatName);
            return;
        }
        if (!format.isOfFormat(f) && !args.hasFlag('f')) {
            player.printError(fileName + " is not of the " + format.getName() + " schematic format!");
            return;
        }
        try {
            String filePath = f.getCanonicalPath();
            String dirPath = dir.getCanonicalPath();
            if (!filePath.substring(0, dirPath.length()).equals(dirPath)) {
                player.printError("Schematic could not read or it does not exist.");
            } else {
                session.setClipboard(format.load(f));
                WorldEdit.logger.info(player.getName() + " loaded " + filePath);
                player.print(fileName + " loaded. Paste it with //paste");
            }
        }
        catch (DataException e) {
            player.printError("Load error: " + e.getMessage());
        }
        catch (IOException e) {
            player.printError("Schematic could not read or it does not exist: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(aliases={"save", "s"}, usage="[format] <filename>", desc="Save a schematic into your clipboard", help="Save a schematic into your clipboard\nFormat is a format from \"//schematic formats\"\n", min=1, max=2)
    @CommandPermissions(value={"worldedit.clipboard.save", "worldedit.schematic.save"})
    public void save(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException, CommandException {
        SchematicFormat format;
        LocalConfiguration config = this.we.getConfiguration();
        if (args.argsLength() == 1) {
            if (SchematicFormat.getFormats().size() != 1) {
                player.printError("More than one schematic format is available. Please provide the desired format");
                return;
            }
            format = SchematicFormat.getFormats().iterator().next();
        } else {
            format = SchematicFormat.getFormat(args.getString(0));
            if (format == null) {
                player.printError("Unknown schematic format: " + args.getString(0));
                return;
            }
        }
        String filename = args.getString(args.argsLength() - 1);
        File dir = this.we.getWorkingDirectoryFile(config.saveDir);
        File f = this.we.getSafeSaveFile(player, dir, filename, "schematic", "schematic");
        if (!dir.exists() && !dir.mkdir()) {
            player.printError("The storage folder could not be created.");
            return;
        }
        try {
            File parent = f.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new CommandException("Could not create folder for schematics!");
            }
            format.save(session.getClipboard(), f);
            WorldEdit.logger.info(player.getName() + " saved " + f.getCanonicalPath());
            player.print(filename + " saved.");
            return;
        }
        catch (DataException se) {
            player.printError("Save error: " + se.getMessage());
            return;
        }
        catch (IOException e) {
            player.printError("Schematic could not written: " + e.getMessage());
        }
    }

    @Command(aliases={"formats", "listformats", "f"}, desc="List available schematic formats", max=0)
    @Console
    @CommandPermissions(value={"worldedit.schematic.formats"})
    public void formats(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.print("Available schematic formats (Name: Lookup names)");
        boolean first = true;
        for (SchematicFormat format : SchematicFormat.getFormats()) {
            StringBuilder builder = new StringBuilder();
            builder.append(format.getName()).append(": ");
            for (String lookupName : format.getLookupNames()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(lookupName);
                first = false;
            }
            first = true;
            player.print(builder.toString());
        }
    }

    @Command(aliases={"list", "all", "ls"}, desc="List available schematics", max=0)
    @Console
    @CommandPermissions(value={"worldedit.schematic.list"})
    public void list(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        File dir = this.we.getWorkingDirectoryFile(this.we.getConfiguration().saveDir);
        StringBuilder build = new StringBuilder("Available schematics (Filename (Format)): ");
        boolean first = true;
        for (File file : dir.listFiles()) {
            if (!file.isFile()) continue;
            if (!first) {
                build.append(", ");
            }
            SchematicFormat format = SchematicFormat.getFormat(file);
            build.append(file.getName()).append(": ").append(format == null ? "Unknown" : format.getName());
            first = false;
        }
        player.print(build.toString());
    }
}

