/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.BiomeType;
import com.sk89q.worldedit.BiomeTypes;
import com.sk89q.worldedit.UnknownBiomeTypeException;
import com.sk89q.worldedit.spout.SpoutBiomeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spout.api.generator.biome.Biome;
import org.spout.api.generator.biome.BiomeGenerator;

public class SpoutBiomeTypes
implements BiomeTypes {
    private final Map<String, SpoutBiomeType> types = new HashMap<String, SpoutBiomeType>();

    @Override
    public boolean has(String name) {
        return this.types.containsKey(name.toLowerCase());
    }

    @Override
    public SpoutBiomeType get(String name) throws UnknownBiomeTypeException {
        if (!this.has(name)) {
            throw new UnknownBiomeTypeException(name);
        }
        return this.types.get(name.toLowerCase());
    }

    public void registerBiomeTypes(BiomeGenerator generator) {
        for (Biome type : generator.getBiomes()) {
            SpoutBiomeType weType = new SpoutBiomeType(type);
            if (this.types.containsKey(weType.getName())) continue;
            this.types.put(weType.getName(), weType);
        }
    }

    @Override
    public List<BiomeType> all() {
        return new ArrayList<BiomeType>(this.types.values());
    }
}

