/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.spout.SpoutPlayer;
import com.sk89q.worldedit.spout.WorldEditPlugin;
import java.util.Arrays;
import java.util.List;
import org.spout.api.Spout;
import org.spout.api.chat.ChatArguments;
import org.spout.api.chat.ChatSection;
import org.spout.api.event.EventHandler;
import org.spout.api.event.Listener;
import org.spout.api.event.Order;
import org.spout.api.event.player.PlayerInteractEvent;
import org.spout.api.event.player.PlayerLeaveEvent;
import org.spout.api.event.server.PreCommandEvent;
import org.spout.api.event.world.WorldLoadEvent;
import org.spout.api.generator.biome.BiomeGenerator;
import org.spout.api.geo.discrete.Point;
import org.spout.api.scheduler.TaskPriority;

public class WorldEditListener
implements Listener {
    private WorldEditPlugin plugin;
    private boolean ignoreLeftClickAir = false;

    public WorldEditListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerQuit(PlayerLeaveEvent event) {
        this.plugin.getWorldEdit().markExpire(this.plugin.wrapPlayer(event.getPlayer()));
    }

    @EventHandler(order=Order.EARLY)
    public void onPlayerCommandPreprocess(PreCommandEvent event) {
        if (event.getCommand().startsWith("nowe:")) {
            event.setCommand(event.getCommand().substring(5));
            return;
        }
        List args = event.getArguments().toSections(ChatSection.SplitType.WORD);
        if (args.size() > 0) {
            Object[] split = new String[args.size() + 1];
            split[0] = "/" + event.getCommand();
            for (int i = 0; i < args.size(); ++i) {
                split[i + 1] = ((ChatSection)args.get(i)).getPlainString();
            }
            Object[] newSplit = this.plugin.getWorldEdit().commandDetection((String[])split);
            if (!Arrays.equals(split, newSplit)) {
                event.setCommand((String)newSplit[0]);
                ChatArguments newArgs = new ChatArguments(new ChatSection[0]);
                for (int i = 1; i < newSplit.length; ++i) {
                    newArgs.append(newSplit[i]);
                }
                event.setArguments(newArgs);
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        SpoutPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        LocalWorld world = ((LocalPlayer)player).getWorld();
        WorldEdit we = this.plugin.getWorldEdit();
        PlayerInteractEvent.Action action = event.getAction();
        if (action == PlayerInteractEvent.Action.LEFT_CLICK) {
            int taskId;
            Point clickedBlock;
            WorldVector pos;
            if (event.isAir() && this.ignoreLeftClickAir) {
                return;
            }
            if (!event.isAir() && we.handleBlockLeftClick(player, pos = new WorldVector(world, (clickedBlock = event.getInteractedPoint()).getBlockX(), clickedBlock.getBlockY(), clickedBlock.getBlockZ()))) {
                event.setCancelled(true);
            }
            if (we.handleArmSwing(player)) {
                event.setCancelled(true);
            }
            if (!event.isAir() && !this.ignoreLeftClickAir && (taskId = Spout.getEngine().getScheduler().scheduleSyncDelayedTask((Object)this.plugin, new Runnable(){

                @Override
                public void run() {
                    WorldEditListener.this.ignoreLeftClickAir = false;
                }
            }, 100L, TaskPriority.NORMAL)) != -1) {
                this.ignoreLeftClickAir = true;
            }
        } else if (action == PlayerInteractEvent.Action.RIGHT_CLICK) {
            Point clickedBlock;
            WorldVector pos;
            if (!event.isAir() && we.handleBlockRightClick(player, pos = new WorldVector(world, (clickedBlock = event.getInteractedPoint()).getBlockX(), clickedBlock.getBlockY(), clickedBlock.getBlockZ()))) {
                event.setCancelled(true);
            }
            if (we.handleRightClick(player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        if (event.getWorld().getGenerator() instanceof BiomeGenerator) {
            this.plugin.getServerInterface().getBiomes().registerBiomeTypes((BiomeGenerator)event.getWorld().getGenerator());
        }
    }
}

