/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.MobType;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.data.DataException;
import java.util.HashMap;
import java.util.Map;

public class MobSpawnerBlock
extends BaseBlock
implements TileEntityBlock {
    private String mobType;
    private short delay;

    public MobSpawnerBlock() {
        super(52);
        this.mobType = MobType.PIG.getName();
    }

    public MobSpawnerBlock(String mobType) {
        super(52);
        this.mobType = mobType;
    }

    public MobSpawnerBlock(int data) {
        super(52, data);
    }

    public MobSpawnerBlock(int data, String mobType) {
        super(52, data);
        this.mobType = mobType;
    }

    public String getMobType() {
        return this.mobType;
    }

    public void setMobType(String mobType) {
        this.mobType = mobType;
    }

    public short getDelay() {
        return this.delay;
    }

    public void setDelay(short delay) {
        this.delay = delay;
    }

    @Override
    public boolean hasNbtData() {
        return true;
    }

    @Override
    public String getNbtId() {
        return "MobSpawner";
    }

    @Override
    public CompoundTag getNbtData() {
        HashMap<String, Tag> values = new HashMap<String, Tag>();
        values.put("EntityId", new StringTag("EntityId", this.mobType));
        values.put("Delay", new ShortTag("Delay", this.delay));
        return new CompoundTag(this.getNbtId(), values);
    }

    @Override
    public void setNbtData(CompoundTag rootTag) throws DataException {
        if (rootTag == null) {
            return;
        }
        Object values = rootTag.getValue();
        Tag t = (Tag)values.get("id");
        if (!(t instanceof StringTag) || !((StringTag)t).getValue().equals("MobSpawner")) {
            throw new DataException("'MobSpawner' tile entity expected");
        }
        StringTag mobTypeTag = NBTUtils.getChildTag((Map<String, Tag>)values, "EntityId", StringTag.class);
        ShortTag delayTag = NBTUtils.getChildTag((Map<String, Tag>)values, "Delay", ShortTag.class);
        this.mobType = mobTypeTag.getValue();
        this.delay = delayTag.getValue();
    }
}

