/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sk89q.worldedit.LocalEntity;
import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.spout.SpoutUtil;
import com.sk89q.worldedit.spout.SpoutWorld;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.spout.api.component.Component;
import org.spout.api.datatable.ManagedHashMap;
import org.spout.api.entity.Entity;
import org.spout.api.geo.LoadOption;
import org.spout.api.geo.World;
import org.spout.api.geo.discrete.Point;

public class SpoutEntity
extends LocalEntity {
    private final byte[] datatableBytes;
    private final List<Class<? extends Component>> components;
    private final int entityId;

    public SpoutEntity(Location position, int id, Collection<Class<? extends Component>> components, ManagedHashMap datatable) {
        super(position);
        this.components = Lists.newArrayList(components);
        this.datatableBytes = datatable.serialize();
        this.entityId = id;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public boolean spawn(Location loc) {
        World world = ((SpoutWorld)loc.getWorld()).getWorld();
        Point pos = SpoutUtil.toPoint(world, loc.getPosition());
        Class<? extends Component> mainComponent = null;
        if (this.components.size() > 0) {
            mainComponent = this.components.get(0);
        }
        if (mainComponent == null) {
            return false;
        }
        Entity e = world.createAndSpawnEntity(pos, mainComponent, LoadOption.LOAD_ONLY);
        if (e != null) {
            e.getTransform().setPitch(loc.getPitch());
            e.getTransform().setYaw(loc.getYaw());
            for (Class clazz : Iterables.skip(this.components, (int)1)) {
                e.add(clazz);
            }
            try {
                e.getData().deserialize(this.datatableBytes, true);
            }
            catch (IOException e1) {
                return false;
            }
            return true;
        }
        return false;
    }
}

