/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.OutOfBlocksException;
import com.sk89q.worldedit.bags.OutOfSpaceException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import org.spout.api.entity.Player;
import org.spout.api.inventory.ItemStack;
import org.spout.api.material.Material;
import org.spout.vanilla.component.inventory.PlayerInventory;
import org.spout.vanilla.component.living.Human;
import org.spout.vanilla.material.VanillaMaterials;

public class SpoutPlayerBlockBag
extends BlockBag {
    private Player player;
    private ItemInfo items;

    public SpoutPlayerBlockBag(Player player) {
        this.player = player;
    }

    private void loadInventory() {
        if (this.items == null) {
            this.items = this.getViewableItems(this.player);
        }
    }

    private ItemInfo getViewableItems(Player player) {
        int index;
        ItemStack[] items;
        boolean includesFullInventory = true;
        Human human = (Human)player.get(Human.class);
        PlayerInventory inv = human.getInventory();
        if (human.isCreative()) {
            includesFullInventory = false;
            items = new ItemStack[inv.getQuickbar().size()];
        } else {
            items = new ItemStack[inv.getQuickbar().size() + inv.getMain().size()];
        }
        for (index = 0; index < inv.getQuickbar().size(); ++index) {
            items[index] = inv.getQuickbar().get(index);
        }
        if (!human.isCreative()) {
            for (int i = 0; i < inv.getMain().size() && index < items.length; ++i) {
                items[index++] = inv.getMain().get(i);
            }
        }
        return new ItemInfo(items, includesFullInventory);
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void fetchItem(BaseItem item) throws BlockBagException {
        int amount;
        short id = (short)item.getType();
        short damage = item.getData();
        int n = amount = item instanceof BaseItemStack ? ((BaseItemStack)item).getAmount() : 1;
        assert (amount == 1);
        Material mat = VanillaMaterials.getMaterial((short)id, (short)damage);
        if (mat == VanillaMaterials.AIR) {
            throw new IllegalArgumentException("Can't fetch air block");
        }
        this.loadInventory();
        boolean found = false;
        for (int slot = 0; slot < this.items.inventory.length; ++slot) {
            ItemStack spoutItem = this.items.inventory[slot];
            if (spoutItem == null || !spoutItem.getMaterial().equals((Object)mat)) continue;
            int currentAmount = spoutItem.getAmount();
            if (currentAmount < 0) {
                return;
            }
            if (currentAmount > 1) {
                spoutItem.setAmount(currentAmount - 1);
                found = true;
                break;
            }
            this.items.inventory[slot] = null;
            found = true;
            break;
        }
        if (!found) {
            throw new OutOfBlocksException();
        }
    }

    @Override
    public void storeItem(BaseItem item) throws BlockBagException {
        int amount;
        short id = (short)item.getType();
        short damage = item.getData();
        Material mat = VanillaMaterials.getMaterial((short)id, (short)damage);
        int n = amount = item instanceof BaseItemStack ? ((BaseItemStack)item).getAmount() : 1;
        assert (amount <= mat.getMaxStackSize());
        if (mat == VanillaMaterials.AIR) {
            throw new IllegalArgumentException("Can't store air block");
        }
        this.loadInventory();
        int freeSlot = -1;
        for (int slot = 0; slot < this.items.inventory.length; ++slot) {
            ItemStack spoutItem = this.items.inventory[slot];
            if (spoutItem == null) {
                if (freeSlot != -1) continue;
                freeSlot = slot;
                continue;
            }
            if (!spoutItem.getMaterial().equals((Object)mat)) continue;
            int currentAmount = spoutItem.getAmount();
            if (currentAmount < 0) {
                return;
            }
            if (currentAmount >= mat.getMaxStackSize()) continue;
            int spaceLeft = mat.getMaxStackSize() - currentAmount;
            if (spaceLeft >= amount) {
                spoutItem.setAmount(currentAmount + amount);
                return;
            }
            spoutItem.setAmount(mat.getMaxStackSize());
            amount -= spaceLeft;
        }
        if (freeSlot > -1) {
            this.items.inventory[freeSlot] = new ItemStack(mat, amount);
            return;
        }
        throw new OutOfSpaceException(id);
    }

    @Override
    public void flushChanges() {
        if (this.items != null) {
            int i;
            PlayerInventory inv = ((Human)this.player.get(Human.class)).getInventory();
            for (i = 0; i < inv.getQuickbar().size(); ++i) {
                inv.getQuickbar().set(i, this.items.inventory[i]);
            }
            for (i = 0; i < inv.getMain().size(); ++i) {
                inv.getMain().set(i, this.items.inventory[inv.getQuickbar().size() + i]);
            }
            this.items = null;
        }
    }

    @Override
    public void addSourcePosition(WorldVector pos) {
    }

    @Override
    public void addSingleSourcePosition(WorldVector pos) {
    }

    private static class ItemInfo {
        ItemStack[] inventory;
        boolean includesFullInventory;

        public ItemInfo(ItemStack[] inventory, boolean full) {
            this.inventory = inventory;
            this.includesFullInventory = full;
        }
    }
}

