/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.spout.WorldEditCUIMessage;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.spout.api.protocol.MessageCodec;
import org.spout.api.util.Named;

public class WorldEditCUICodec
extends MessageCodec<WorldEditCUIMessage>
implements Named {
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");

    public WorldEditCUICodec(int opcode) {
        super(WorldEditCUIMessage.class, opcode);
    }

    public ChannelBuffer encode(WorldEditCUIMessage message) {
        byte[] data = message.getMessage().getBytes(UTF_8_CHARSET);
        ChannelBuffer buffer = ChannelBuffers.buffer((int)data.length);
        buffer.writeBytes(data);
        return buffer;
    }

    public WorldEditCUIMessage decode(ChannelBuffer buffer) {
        byte[] data = new byte[buffer.readableBytes()];
        buffer.readBytes(data);
        String message = new String(data, UTF_8_CHARSET);
        return new WorldEditCUIMessage(message);
    }

    public String getName() {
        return "WECUI";
    }
}

