/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.spout.SpoutWorld;
import com.sk89q.worldedit.spout.WorldEditPlugin;
import java.util.HashMap;
import java.util.Map;
import org.spout.api.Engine;
import org.spout.api.Server;
import org.spout.api.Source;
import org.spout.api.entity.Entity;
import org.spout.api.entity.Player;
import org.spout.api.geo.World;
import org.spout.api.geo.cuboid.Block;
import org.spout.api.geo.discrete.Point;
import org.spout.api.material.block.BlockFace;
import org.spout.api.math.MathHelper;
import org.spout.api.math.Vector3;

public class SpoutUtil {
    private static final Map<World, LocalWorld> wlw = new HashMap<World, LocalWorld>();

    private SpoutUtil() {
    }

    public static LocalWorld getLocalWorld(World w) {
        LocalWorld lw = wlw.get(w);
        if (lw == null) {
            lw = new SpoutWorld(w);
            wlw.put(w, lw);
        }
        return lw;
    }

    public static BlockVector toVector(Block block) {
        return new BlockVector(block.getX(), block.getY(), block.getZ());
    }

    public static BlockVector toVector(BlockFace face) {
        return SpoutUtil.toBlockVector(face.getOffset());
    }

    public static BlockVector toBlockVector(Vector3 vector) {
        return new BlockVector(vector.getX(), vector.getY(), vector.getZ());
    }

    public static BlockWorldVector toWorldVector(Block block) {
        return new BlockWorldVector(SpoutUtil.getLocalWorld(block.getWorld()), block.getX(), block.getY(), block.getZ());
    }

    public static Vector toVector(Point loc) {
        return new Vector(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Vector toVector(Vector3 vector) {
        return new Vector(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Point toPoint(WorldVector pt) {
        return new Point(SpoutUtil.toWorld(pt), (float)pt.getX(), (float)pt.getY(), (float)pt.getZ());
    }

    public static Point toPoint(World world, Vector pt) {
        return new Point(world, (float)pt.getX(), (float)pt.getY(), (float)pt.getZ());
    }

    public static Point center(Point loc) {
        return new Point(loc.getWorld(), (float)MathHelper.floor((float)loc.getX()) + 0.5f, (float)MathHelper.floor((float)loc.getY()) + 0.5f, (float)MathHelper.floor((float)loc.getZ()) + 0.5f);
    }

    public static Player matchSinglePlayer(Engine game, String name) {
        return game instanceof Server ? ((Server)game).getPlayer(name, false) : null;
    }

    public static Block toBlock(BlockWorldVector pt) {
        return SpoutUtil.toWorld(pt).getBlock(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ(), (Source)WorldEditPlugin.getInstance());
    }

    public static World toWorld(WorldVector pt) {
        return ((SpoutWorld)pt.getWorld()).getWorld();
    }

    public static Location toLocation(Entity ent) {
        return new Location(SpoutUtil.getLocalWorld(ent.getWorld()), SpoutUtil.toVector(ent.getTransform().getPosition()), ent.getTransform().getYaw(), ent.getTransform().getPitch());
    }
}

