/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.jchronic.Chronic;
import com.sk89q.jchronic.Options;
import com.sk89q.jchronic.utils.Span;
import com.sk89q.jchronic.utils.Time;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.InvalidToolBindException;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.cui.CUIEvent;
import com.sk89q.worldedit.cui.CUIRegion;
import com.sk89q.worldedit.cui.SelectionShapeEvent;
import com.sk89q.worldedit.masks.Mask;
import com.sk89q.worldedit.regions.CuboidRegionSelector;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.snapshots.Snapshot;
import com.sk89q.worldedit.tools.BlockTool;
import com.sk89q.worldedit.tools.BrushTool;
import com.sk89q.worldedit.tools.SinglePickaxe;
import com.sk89q.worldedit.tools.Tool;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;

public class LocalSession {
    public static int MAX_HISTORY_SIZE = 15;
    public static int EXPIRATION_GRACE = 600000;
    private LocalConfiguration config;
    private long expirationTime = System.currentTimeMillis() + (long)EXPIRATION_GRACE;
    private RegionSelector selector = new CuboidRegionSelector();
    private boolean placeAtPos1 = false;
    private LinkedList<EditSession> history = new LinkedList();
    private int historyPointer = 0;
    private CuboidClipboard clipboard;
    private boolean toolControl = true;
    private boolean superPickaxe = false;
    private BlockTool pickaxeMode = new SinglePickaxe();
    private Map<Integer, Tool> tools = new HashMap<Integer, Tool>();
    private int maxBlocksChanged = -1;
    private boolean useInventory;
    private Snapshot snapshot;
    private String lastScript;
    private boolean beenToldVersion = false;
    private boolean hasCUISupport = false;
    private int cuiVersion = -1;
    private boolean fastMode = false;
    private Mask mask;
    private TimeZone timezone = TimeZone.getDefault();

    public LocalSession(LocalConfiguration config) {
        this.config = config;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public void clearHistory() {
        this.history.clear();
        this.historyPointer = 0;
    }

    public void remember(EditSession editSession) {
        if (editSession.size() == 0) {
            return;
        }
        while (this.historyPointer < this.history.size()) {
            this.history.remove(this.historyPointer);
        }
        this.history.add(editSession);
        while (this.history.size() > MAX_HISTORY_SIZE) {
            this.history.remove(0);
        }
        this.historyPointer = this.history.size();
    }

    public EditSession undo(BlockBag newBlockBag) {
        --this.historyPointer;
        if (this.historyPointer >= 0) {
            EditSession editSession = this.history.get(this.historyPointer);
            EditSession newEditSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(editSession.getWorld(), -1, newBlockBag);
            newEditSession.enableQueue();
            newEditSession.setFastMode(this.fastMode);
            editSession.undo(newEditSession);
            return editSession;
        }
        this.historyPointer = 0;
        return null;
    }

    public EditSession redo(BlockBag newBlockBag) {
        if (this.historyPointer < this.history.size()) {
            EditSession editSession = this.history.get(this.historyPointer);
            EditSession newEditSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(editSession.getWorld(), -1, newBlockBag);
            newEditSession.enableQueue();
            newEditSession.setFastMode(this.fastMode);
            editSession.redo(newEditSession);
            ++this.historyPointer;
            return editSession;
        }
        return null;
    }

    public RegionSelector getRegionSelector(LocalWorld world) {
        if (this.selector.getIncompleteRegion().getWorld() == null) {
            this.selector = new CuboidRegionSelector(world);
        } else if (!this.selector.getIncompleteRegion().getWorld().equals(world)) {
            this.selector.getIncompleteRegion().setWorld(world);
            this.selector.clear();
        }
        return this.selector;
    }

    @Deprecated
    public RegionSelector getRegionSelector() {
        return this.selector;
    }

    public void setRegionSelector(LocalWorld world, RegionSelector selector) {
        selector.getIncompleteRegion().setWorld(world);
        this.selector = selector;
    }

    @Deprecated
    public boolean isRegionDefined() {
        return this.selector.isDefined();
    }

    public boolean isSelectionDefined(LocalWorld world) {
        if (this.selector.getIncompleteRegion().getWorld() == null || !this.selector.getIncompleteRegion().getWorld().equals(world)) {
            return false;
        }
        return this.selector.isDefined();
    }

    @Deprecated
    public Region getRegion() throws IncompleteRegionException {
        return this.selector.getRegion();
    }

    public Region getSelection(LocalWorld world) throws IncompleteRegionException {
        if (this.selector.getIncompleteRegion().getWorld() == null || !this.selector.getIncompleteRegion().getWorld().equals(world)) {
            throw new IncompleteRegionException();
        }
        return this.selector.getRegion();
    }

    public LocalWorld getSelectionWorld() {
        return this.selector.getIncompleteRegion().getWorld();
    }

    public CuboidClipboard getClipboard() throws EmptyClipboardException {
        if (this.clipboard == null) {
            throw new EmptyClipboardException();
        }
        return this.clipboard;
    }

    public void setClipboard(CuboidClipboard clipboard) {
        this.clipboard = clipboard;
    }

    public boolean isToolControlEnabled() {
        return this.toolControl;
    }

    public void setToolControl(boolean toolControl) {
        this.toolControl = toolControl;
    }

    public int getBlockChangeLimit() {
        return this.maxBlocksChanged;
    }

    public void setBlockChangeLimit(int maxBlocksChanged) {
        this.maxBlocksChanged = maxBlocksChanged;
    }

    public boolean hasSuperPickAxe() {
        return this.superPickaxe;
    }

    public void enableSuperPickAxe() {
        this.superPickaxe = true;
    }

    public void disableSuperPickAxe() {
        this.superPickaxe = false;
    }

    public boolean toggleSuperPickAxe() {
        this.superPickaxe = !this.superPickaxe;
        return this.superPickaxe;
    }

    public Vector getPlacementPosition(LocalPlayer player) throws IncompleteRegionException {
        if (!this.placeAtPos1) {
            return player.getBlockIn();
        }
        return this.selector.getPrimaryPosition();
    }

    public boolean togglePlacementPosition() {
        this.placeAtPos1 = !this.placeAtPos1;
        return this.placeAtPos1;
    }

    public BlockBag getBlockBag(LocalPlayer player) {
        if (!this.useInventory) {
            return null;
        }
        return player.getInventoryBlockBag();
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public BlockTool getSuperPickaxe() {
        return this.pickaxeMode;
    }

    public void setSuperPickaxe(BlockTool tool) {
        this.pickaxeMode = tool;
    }

    public Tool getTool(int item) {
        return this.tools.get(item);
    }

    public BrushTool getBrushTool(int item) throws InvalidToolBindException {
        Tool tool = this.getTool(item);
        if (tool == null || !(tool instanceof BrushTool)) {
            tool = new BrushTool("worldedit.brush.sphere");
            this.setTool(item, tool);
        }
        return (BrushTool)tool;
    }

    public void setTool(int item, Tool tool) throws InvalidToolBindException {
        if (item > 0 && item < 255) {
            throw new InvalidToolBindException(item, "Blocks can't be used");
        }
        if (item == this.config.wandItem) {
            throw new InvalidToolBindException(item, "Already used for the wand");
        }
        if (item == this.config.navigationWand) {
            throw new InvalidToolBindException(item, "Already used for the navigation wand");
        }
        this.tools.put(item, tool);
    }

    public boolean isUsingInventory() {
        return this.useInventory;
    }

    public void setUseInventory(boolean useInventory) {
        this.useInventory = useInventory;
    }

    public String getLastScript() {
        return this.lastScript;
    }

    public void setLastScript(String lastScript) {
        this.lastScript = lastScript;
    }

    public void tellVersion(LocalPlayer player) {
        if (this.config.showFirstUseVersion && !this.beenToldVersion) {
            player.printRaw("\u00a78WorldEdit ver. " + WorldEdit.getVersion() + " (http://sk89q.com/projects/worldedit/)");
            this.beenToldVersion = true;
        }
    }

    public void dispatchCUIEvent(LocalPlayer player, CUIEvent event) {
        if (this.hasCUISupport) {
            player.dispatchCUIEvent(event);
        }
    }

    public void dispatchCUISetup(LocalPlayer player) {
        if (this.selector != null) {
            this.dispatchCUISelection(player);
        }
    }

    public void dispatchCUISelection(LocalPlayer player) {
        if (!this.hasCUISupport) {
            return;
        }
        if (this.selector instanceof CUIRegion) {
            CUIRegion tempSel = (CUIRegion)((Object)this.selector);
            if (tempSel.getProtocolVersion() > this.cuiVersion) {
                player.dispatchCUIEvent(new SelectionShapeEvent(tempSel.getLegacyTypeID()));
                tempSel.describeLegacyCUI(this, player);
            } else {
                player.dispatchCUIEvent(new SelectionShapeEvent(tempSel.getTypeID()));
                tempSel.describeCUI(this, player);
            }
        }
    }

    public void describeCUI(LocalPlayer player) {
        if (!this.hasCUISupport) {
            return;
        }
        if (this.selector instanceof CUIRegion) {
            CUIRegion tempSel = (CUIRegion)((Object)this.selector);
            if (tempSel.getProtocolVersion() > this.cuiVersion) {
                tempSel.describeLegacyCUI(this, player);
            } else {
                tempSel.describeCUI(this, player);
            }
        }
    }

    public void handleCUIInitializationMessage(String text) {
        if (this.hasCUISupport()) {
            return;
        }
        String[] split = text.split("\\|");
        if (split.length > 1 && split[0].equalsIgnoreCase("v")) {
            this.setCUISupport(true);
            try {
                this.setCUIVersion(Integer.parseInt(split[1]));
            }
            catch (NumberFormatException e) {
                WorldEdit.logger.warning("Error while reading CUI init message: " + e.getMessage());
            }
        }
    }

    public boolean hasCUISupport() {
        return this.hasCUISupport;
    }

    public void setCUISupport(boolean support) {
        this.hasCUISupport = support;
    }

    public int getCUIVersion() {
        return this.cuiVersion;
    }

    public void setCUIVersion(int CUIVersion) {
        this.cuiVersion = CUIVersion;
    }

    public Calendar detectDate(String input) {
        Time.setTimeZone(this.getTimeZone());
        Options opt = new Options();
        opt.setNow(Calendar.getInstance(this.getTimeZone()));
        Span date = Chronic.parse(input, opt);
        if (date == null) {
            return null;
        }
        return date.getBeginCalendar();
    }

    public void update() {
        this.expirationTime = System.currentTimeMillis();
    }

    public boolean hasExpired() {
        return System.currentTimeMillis() - this.expirationTime > (long)EXPIRATION_GRACE;
    }

    public EditSession createEditSession(LocalPlayer player) {
        BlockBag blockBag = this.getBlockBag(player);
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(player.isPlayer() ? player.getWorld() : null, this.getBlockChangeLimit(), blockBag);
        editSession.setFastMode(this.fastMode);
        if (this.mask != null) {
            this.mask.prepare(this, player, null);
        }
        editSession.setMask(this.mask);
        return editSession;
    }

    public boolean hasFastMode() {
        return this.fastMode;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        this.mask = mask;
    }
}

