/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LogFormat;
import com.sk89q.worldedit.snapshots.SnapshotRepository;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class YAMLConfiguration
extends LocalConfiguration {
    protected final YAMLProcessor config;
    protected final Logger logger;
    private FileHandler logFileHandler;

    public YAMLConfiguration(YAMLProcessor config, Logger logger) {
        this.config = config;
        this.logger = logger;
    }

    @Override
    public void load() {
        String type;
        try {
            this.config.load();
        }
        catch (IOException e) {
            this.logger.severe("Error loading WorldEdit configuration: " + e);
            e.printStackTrace();
        }
        this.showFirstUseVersion = false;
        this.profile = this.config.getBoolean("debug", this.profile);
        this.wandItem = this.config.getInt("wand-item", this.wandItem);
        this.defaultChangeLimit = Math.max(-1, this.config.getInt("limits.max-blocks-changed.default", this.defaultChangeLimit));
        this.maxChangeLimit = Math.max(-1, this.config.getInt("limits.max-blocks-changed.maximum", this.maxChangeLimit));
        this.defaultMaxPolygonalPoints = Math.max(-1, this.config.getInt("limits.max-polygonal-points.default", this.defaultMaxPolygonalPoints));
        this.maxPolygonalPoints = Math.max(-1, this.config.getInt("limits.max-polygonal-points.maximum", this.maxPolygonalPoints));
        this.maxRadius = Math.max(-1, this.config.getInt("limits.max-radius", this.maxRadius));
        this.maxSuperPickaxeSize = Math.max(1, this.config.getInt("limits.max-super-pickaxe-size", this.maxSuperPickaxeSize));
        this.registerHelp = true;
        this.logCommands = this.config.getBoolean("logging.log-commands", this.logCommands);
        this.superPickaxeDrop = this.config.getBoolean("super-pickaxe.drop-items", this.superPickaxeDrop);
        this.superPickaxeManyDrop = this.config.getBoolean("super-pickaxe.many-drop-items", this.superPickaxeManyDrop);
        this.noDoubleSlash = this.config.getBoolean("no-double-slash", this.noDoubleSlash);
        this.useInventory = this.config.getBoolean("use-inventory.enable", this.useInventory);
        this.useInventoryOverride = this.config.getBoolean("use-inventory.allow-override", this.useInventoryOverride);
        this.maxBrushRadius = this.config.getInt("limits.max-brush-radius", this.maxBrushRadius);
        this.navigationWand = this.config.getInt("navigation-wand.item", this.navigationWand);
        this.navigationWandMaxDistance = this.config.getInt("navigation-wand.max-distance", this.navigationWandMaxDistance);
        this.scriptTimeout = this.config.getInt("scripting.timeout", this.scriptTimeout);
        this.scriptsDir = this.config.getString("scripting.dir", this.scriptsDir);
        this.butcherDefaultRadius = this.config.getInt("butcher-default-radius", this.butcherDefaultRadius);
        this.saveDir = this.config.getString("saving.dir", this.saveDir);
        this.disallowedBlocks = new HashSet<Integer>(this.config.getIntList("limits.disallowed-blocks", null));
        this.allowedDataCycleBlocks = new HashSet<Integer>(this.config.getIntList("limits.allowed-data-cycle-blocks", null));
        LocalSession.MAX_HISTORY_SIZE = Math.max(0, this.config.getInt("history.size", 15));
        LocalSession.EXPIRATION_GRACE = this.config.getInt("history.expiration", 10) * 60 * 1000;
        String snapshotsDir = this.config.getString("snapshots.directory", "");
        if (snapshotsDir.length() > 0) {
            this.snapshotRepo = new SnapshotRepository(snapshotsDir);
        }
        this.shellSaveType = (type = this.config.getString("shell-save-type", "").trim()).equals("") ? null : type;
        String logFile = this.config.getString("logging.file", "");
        if (!logFile.equals("")) {
            try {
                this.logFileHandler = new FileHandler(new File(this.getWorkingDirectory(), logFile).getAbsolutePath(), true);
                this.logFileHandler.setFormatter(new LogFormat());
                this.logger.addHandler(this.logFileHandler);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Could not use log file " + logFile + ": " + e.getMessage());
            }
        } else {
            for (Handler handler : this.logger.getHandlers()) {
                this.logger.removeHandler(handler);
            }
        }
    }

    public void unload() {
        if (this.logFileHandler != null) {
            this.logFileHandler.close();
        }
    }
}

