/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandAlias;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.Countable;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.cui.CUIRegion;
import com.sk89q.worldedit.data.ChunkStore;
import com.sk89q.worldedit.regions.CuboidRegionSelector;
import com.sk89q.worldedit.regions.CylinderRegionSelector;
import com.sk89q.worldedit.regions.EllipsoidRegionSelector;
import com.sk89q.worldedit.regions.ExtendingCuboidRegionSelector;
import com.sk89q.worldedit.regions.Polygonal2DRegionSelector;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.SphereRegionSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SelectionCommands {
    private final WorldEdit we;

    public SelectionCommands(WorldEdit we) {
        this.we = we;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Command(aliases={"/pos1"}, usage="[coordinates]", desc="Set position 1", min=0, max=1)
    @Logging(value=Logging.LogMode.POSITION)
    @CommandPermissions(value={"worldedit.selection.pos"})
    public void pos1(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        void var5_8;
        if (args.argsLength() == 1) {
            if (!args.getString(0).matches("-?\\d+,-?\\d+,-?\\d+")) {
                player.printError("Invalid coordinates " + args.getString(0));
                return;
            }
            String[] coords = args.getString(0).split(",");
            Vector vector = new Vector(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
        } else {
            WorldVector worldVector = player.getBlockIn();
        }
        if (!session.getRegionSelector(player.getWorld()).selectPrimary((Vector)var5_8)) {
            player.printError("Position already set.");
            return;
        }
        session.getRegionSelector(player.getWorld()).explainPrimarySelection(player, session, (Vector)var5_8);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Command(aliases={"/pos2"}, usage="[coordinates]", desc="Set position 2", min=0, max=1)
    @Logging(value=Logging.LogMode.POSITION)
    @CommandPermissions(value={"worldedit.selection.pos"})
    public void pos2(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        void var5_8;
        if (args.argsLength() == 1) {
            if (!args.getString(0).matches("-?\\d+,-?\\d+,-?\\d+")) {
                player.printError("Invalid coordinates " + args.getString(0));
                return;
            }
            String[] coords = args.getString(0).split(",");
            Vector vector = new Vector(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
        } else {
            WorldVector worldVector = player.getBlockIn();
        }
        if (!session.getRegionSelector(player.getWorld()).selectSecondary((Vector)var5_8)) {
            player.printError("Position already set.");
            return;
        }
        session.getRegionSelector(player.getWorld()).explainSecondarySelection(player, session, (Vector)var5_8);
    }

    @Command(aliases={"/hpos1"}, usage="", desc="Set position 1 to targeted block", min=0, max=0)
    @CommandPermissions(value={"worldedit.selection.hpos"})
    public void hpos1(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        WorldVector pos = player.getBlockTrace(300);
        if (pos != null) {
            if (!session.getRegionSelector(player.getWorld()).selectPrimary(pos)) {
                player.printError("Position already set.");
                return;
            }
            session.getRegionSelector(player.getWorld()).explainPrimarySelection(player, session, pos);
        } else {
            player.printError("No block in sight!");
        }
    }

    @Command(aliases={"/hpos2"}, usage="", desc="Set position 2 to targeted block", min=0, max=0)
    @CommandPermissions(value={"worldedit.selection.hpos"})
    public void hpos2(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        WorldVector pos = player.getBlockTrace(300);
        if (pos != null) {
            if (!session.getRegionSelector(player.getWorld()).selectSecondary(pos)) {
                player.printError("Position already set.");
                return;
            }
            session.getRegionSelector(player.getWorld()).explainSecondarySelection(player, session, pos);
        } else {
            player.printError("No block in sight!");
        }
    }

    @Command(aliases={"/chunk"}, usage="", flags="s", desc="Set the selection to your current chunk.", help="Set the selection to the chunk you are currently in.\nWith the -s flag, your current selection is expanded\nto encompass all chunks that are part of it.", min=0, max=0)
    @Logging(value=Logging.LogMode.POSITION)
    @CommandPermissions(value={"worldedit.selection.chunk"})
    public void chunk(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector max;
        Vector min;
        LocalWorld world = player.getWorld();
        if (args.hasFlag('s')) {
            Region region = session.getSelection(world);
            BlockVector2D min2D = ChunkStore.toChunk(region.getMinimumPoint());
            BlockVector2D max2D = ChunkStore.toChunk(region.getMaximumPoint());
            min = new Vector(min2D.getBlockX() * 16, 0, min2D.getBlockZ() * 16);
            max = new Vector(max2D.getBlockX() * 16 + 15, world.getMaxY(), max2D.getBlockZ() * 16 + 15);
            player.print("Chunks selected: (" + min2D.getBlockX() + ", " + min2D.getBlockZ() + ") - (" + max2D.getBlockX() + ", " + max2D.getBlockZ() + ")");
        } else {
            BlockVector2D min2D = ChunkStore.toChunk(player.getBlockIn());
            min = new Vector(min2D.getBlockX() * 16, 0, min2D.getBlockZ() * 16);
            max = min.add(15, world.getMaxY(), 15);
            player.print("Chunk selected: " + min2D.getBlockX() + ", " + min2D.getBlockZ());
        }
        CuboidRegionSelector selector = session.getRegionSelector(world) instanceof ExtendingCuboidRegionSelector ? new ExtendingCuboidRegionSelector(world) : new CuboidRegionSelector(world);
        selector.selectPrimary(min);
        selector.selectSecondary(max);
        session.setRegionSelector(world, selector);
        session.dispatchCUISelection(player);
    }

    @Command(aliases={"/wand"}, usage="", desc="Get the wand object", min=0, max=0)
    @CommandPermissions(value={"worldedit.wand"})
    public void wand(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.giveItem(this.we.getConfiguration().wandItem, 1);
        player.print("Left click: select pos #1; Right click: select pos #2");
    }

    @Command(aliases={"toggleeditwand"}, usage="", desc="Toggle functionality of the edit wand", min=0, max=0)
    @CommandPermissions(value={"worldedit.wand.toggle"})
    public void toggleWand(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setToolControl(!session.isToolControlEnabled());
        if (session.isToolControlEnabled()) {
            player.print("Edit wand enabled.");
        } else {
            player.print("Edit wand disabled.");
        }
    }

    @Command(aliases={"/expand"}, usage="<amount> [reverse-amount] <direction>", desc="Expand the selection area", min=1, max=3)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.selection.expand"})
    public void expand(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector dir;
        if (args.getString(0).equalsIgnoreCase("vert") || args.getString(0).equalsIgnoreCase("vertical")) {
            Region region = session.getSelection(player.getWorld());
            try {
                int oldSize = region.getArea();
                region.expand(new Vector(0, player.getWorld().getMaxY() + 1, 0), new Vector(0, -(player.getWorld().getMaxY() + 1), 0));
                session.getRegionSelector(player.getWorld()).learnChanges();
                int newSize = region.getArea();
                session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
                player.print("Region expanded " + (newSize - oldSize) + " blocks [top-to-bottom].");
            }
            catch (RegionOperationException e) {
                player.printError(e.getMessage());
            }
            return;
        }
        int change = args.getInteger(0);
        int reverseChange = 0;
        switch (args.argsLength()) {
            case 2: {
                try {
                    reverseChange = args.getInteger(1);
                    dir = this.we.getDirection(player, "me");
                }
                catch (NumberFormatException e) {
                    dir = this.we.getDirection(player, args.getString(1).toLowerCase());
                }
                break;
            }
            case 3: {
                reverseChange = args.getInteger(1);
                dir = this.we.getDirection(player, args.getString(2).toLowerCase());
                break;
            }
            default: {
                dir = this.we.getDirection(player, "me");
            }
        }
        Region region = session.getSelection(player.getWorld());
        int oldSize = region.getArea();
        if (reverseChange == 0) {
            region.expand(dir.multiply(change));
        } else {
            region.expand(dir.multiply(change), dir.multiply(-reverseChange));
        }
        session.getRegionSelector(player.getWorld()).learnChanges();
        int newSize = region.getArea();
        session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
        player.print("Region expanded " + (newSize - oldSize) + " blocks.");
    }

    @Command(aliases={"/contract"}, usage="<amount> [reverse-amount] [direction]", desc="Contract the selection area", min=1, max=3)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.selection.contract"})
    public void contract(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector dir;
        int change = args.getInteger(0);
        int reverseChange = 0;
        switch (args.argsLength()) {
            case 2: {
                try {
                    reverseChange = args.getInteger(1);
                    dir = this.we.getDirection(player, "me");
                }
                catch (NumberFormatException e) {
                    dir = this.we.getDirection(player, args.getString(1).toLowerCase());
                }
                break;
            }
            case 3: {
                reverseChange = args.getInteger(1);
                dir = this.we.getDirection(player, args.getString(2).toLowerCase());
                break;
            }
            default: {
                dir = this.we.getDirection(player, "me");
            }
        }
        try {
            Region region = session.getSelection(player.getWorld());
            int oldSize = region.getArea();
            if (reverseChange == 0) {
                region.contract(dir.multiply(change));
            } else {
                region.contract(dir.multiply(change), dir.multiply(-reverseChange));
            }
            session.getRegionSelector(player.getWorld()).learnChanges();
            int newSize = region.getArea();
            session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            player.print("Region contracted " + (oldSize - newSize) + " blocks.");
        }
        catch (RegionOperationException e) {
            player.printError(e.getMessage());
        }
    }

    @Command(aliases={"/shift"}, usage="<amount> [direction]", desc="Shift the selection area", min=1, max=2)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.selection.shift"})
    public void shift(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int change = args.getInteger(0);
        Vector dir = args.argsLength() == 2 ? this.we.getDirection(player, args.getString(1).toLowerCase()) : this.we.getDirection(player, "me");
        try {
            Region region = session.getSelection(player.getWorld());
            region.shift(dir.multiply(change));
            session.getRegionSelector(player.getWorld()).learnChanges();
            session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            player.print("Region shifted.");
        }
        catch (RegionOperationException e) {
            player.printError(e.getMessage());
        }
    }

    @Command(aliases={"/outset"}, usage="<amount>", desc="Outset the selection area", help="Expands the selection by the given amount in all directions.\nFlags:\n  -h only expand horizontally\n  -v only expand vertically\n", flags="hv", min=1, max=1)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.selection.outset"})
    public void outset(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        region.expand(this.getChangesForEachDir(args));
        session.getRegionSelector(player.getWorld()).learnChanges();
        session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
        player.print("Region outset.");
    }

    @Command(aliases={"/inset"}, usage="<amount>", desc="Inset the selection area", help="Contracts the selection by the given amount in all directions.\nFlags:\n  -h only contract horizontally\n  -v only contract vertically\n", flags="hv", min=1, max=1)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.selection.inset"})
    public void inset(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        region.contract(this.getChangesForEachDir(args));
        session.getRegionSelector(player.getWorld()).learnChanges();
        session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
        player.print("Region inset.");
    }

    private Vector[] getChangesForEachDir(CommandContext args) {
        ArrayList<Vector> changes = new ArrayList<Vector>(6);
        int change = args.getInteger(0);
        if (!args.hasFlag('h')) {
            changes.add(new Vector(0, 1, 0).multiply(change));
            changes.add(new Vector(0, -1, 0).multiply(change));
        }
        if (!args.hasFlag('v')) {
            changes.add(new Vector(1, 0, 0).multiply(change));
            changes.add(new Vector(-1, 0, 0).multiply(change));
            changes.add(new Vector(0, 0, 1).multiply(change));
            changes.add(new Vector(0, 0, -1).multiply(change));
        }
        return changes.toArray(new Vector[0]);
    }

    @Command(aliases={"/size"}, flags="c", usage="", desc="Get information about the selection", min=0, max=0)
    @CommandPermissions(value={"worldedit.selection.size"})
    public void size(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (args.hasFlag('c')) {
            CuboidClipboard clipboard = session.getClipboard();
            Vector size = clipboard.getSize();
            Vector offset = clipboard.getOffset();
            player.print("Size: " + size);
            player.print("Offset: " + offset);
            player.print("Cuboid distance: " + size.distance(new Vector(1, 1, 1)));
            player.print("# of blocks: " + (int)(size.getX() * size.getY() * size.getZ()));
            return;
        }
        Region region = session.getSelection(player.getWorld());
        Vector size = region.getMaximumPoint().subtract(region.getMinimumPoint()).add(1, 1, 1);
        player.print("Type: " + session.getRegionSelector(player.getWorld()).getTypeName());
        for (String line : session.getRegionSelector(player.getWorld()).getInformationLines()) {
            player.print(line);
        }
        player.print("Size: " + size);
        player.print("Cuboid distance: " + region.getMaximumPoint().distance(region.getMinimumPoint()));
        player.print("# of blocks: " + region.getArea());
    }

    @Command(aliases={"/count"}, usage="<block>", desc="Counts the number of a certain type of block", min=1, max=1)
    @CommandPermissions(value={"worldedit.analysis.count"})
    public void count(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Set<Integer> searchIDs = this.we.getBlockIDs(player, args.getString(0), true);
        player.print("Counted: " + editSession.countBlocks(session.getSelection(player.getWorld()), searchIDs));
    }

    @Command(aliases={"/distr"}, usage="", desc="Get the distribution of blocks in the selection", help="Gets the distribution of blocks in the selection.\nThe -c flag gets the distribution of your clipboard.", flags="c", min=0, max=0)
    @CommandPermissions(value={"worldedit.analysis.distr"})
    public void distr(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int size;
        List<Countable<Integer>> distribution;
        if (args.hasFlag('c')) {
            CuboidClipboard clip = session.getClipboard();
            distribution = clip.getBlockDistribution();
            size = clip.getHeight() * clip.getLength() * clip.getWidth();
        } else {
            distribution = editSession.getBlockDistribution(session.getSelection(player.getWorld()));
            size = session.getSelection(player.getWorld()).getArea();
        }
        if (distribution.size() <= 0) {
            player.printError("No blocks counted.");
            return;
        }
        player.print("# total blocks: " + size);
        for (Countable<Integer> c : distribution) {
            BlockType block = BlockType.fromID(c.getID());
            String str = String.format("%-7s (%.3f%%) %s #%d", String.valueOf(c.getAmount()), (double)c.getAmount() / (double)size * 100.0, block == null ? "Unknown" : block.getName(), c.getID());
            player.print(str);
        }
    }

    @Command(aliases={"/sel", ";"}, usage="[cuboid|extend|poly|ellipsoid|sphere|cyl]", desc="Choose a region selector", min=0, max=1)
    public void select(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        CUIRegion selector;
        LocalWorld world = player.getWorld();
        if (args.argsLength() == 0) {
            session.getRegionSelector(world).clear();
            session.dispatchCUISelection(player);
            player.print("Selection cleared.");
            return;
        }
        String typeName = args.getString(0);
        RegionSelector oldSelector = session.getRegionSelector(world);
        if (typeName.equalsIgnoreCase("cuboid")) {
            selector = new CuboidRegionSelector(oldSelector);
            player.print("Cuboid: left click for point 1, right click for point 2");
        } else if (typeName.equalsIgnoreCase("extend")) {
            selector = new ExtendingCuboidRegionSelector(oldSelector);
            player.print("Cuboid: left click for a starting point, right click to extend");
        } else if (typeName.equalsIgnoreCase("poly")) {
            int maxPoints = this.we.getMaximumPolygonalPoints(player);
            selector = new Polygonal2DRegionSelector(oldSelector, maxPoints);
            player.print("2D polygon selector: Left/right click to add a point.");
            if (maxPoints > -1) {
                player.print(maxPoints + " points maximum.");
            }
        } else if (typeName.equalsIgnoreCase("ellipsoid")) {
            selector = new EllipsoidRegionSelector(oldSelector);
            player.print("Ellipsoid selector: left click=center, right click to extend");
        } else if (typeName.equalsIgnoreCase("sphere")) {
            selector = new SphereRegionSelector(oldSelector);
            player.print("Sphere selector: left click=center, right click to extend");
        } else if (typeName.equalsIgnoreCase("cyl")) {
            selector = new CylinderRegionSelector(oldSelector);
            player.print("Cylindrical selector: Left click=center, right click to extend.");
        } else {
            player.printError("Only cuboid|extend|poly|ellipsoid|sphere|cyl are accepted.");
            return;
        }
        session.setRegionSelector(world, (RegionSelector)((Object)selector));
        session.dispatchCUISelection(player);
    }

    @Command(aliases={"/desel", "/deselect"}, desc="Deselect the current selection")
    @CommandAlias(value={"/sel"})
    public void deselect() {
    }
}

