/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.masks.BlockMask;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.patterns.SingleBlockPattern;
import com.sk89q.worldedit.tools.BrushTool;
import com.sk89q.worldedit.tools.brushes.ClipboardBrush;
import com.sk89q.worldedit.tools.brushes.CylinderBrush;
import com.sk89q.worldedit.tools.brushes.GravityBrush;
import com.sk89q.worldedit.tools.brushes.HollowCylinderBrush;
import com.sk89q.worldedit.tools.brushes.HollowSphereBrush;
import com.sk89q.worldedit.tools.brushes.SmoothBrush;
import com.sk89q.worldedit.tools.brushes.SphereBrush;

public class BrushCommands {
    private final WorldEdit we;

    public BrushCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"sphere", "s"}, usage="<block> [radius]", flags="h", desc="Choose the sphere brush", help="Chooses the sphere brush.\nThe -h flag creates hollow spheres instead.", min=1, max=2)
    @CommandPermissions(value={"worldedit.brush.sphere"})
    public void sphereBrush(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radius;
        LocalConfiguration config = this.we.getConfiguration();
        double d = radius = args.argsLength() > 1 ? args.getDouble(1) : 2.0;
        if (radius > (double)config.maxBrushRadius) {
            player.printError("Maximum allowed brush radius: " + config.maxBrushRadius);
            return;
        }
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        Pattern fill = this.we.getBlockPattern(player, args.getString(0));
        tool.setFill(fill);
        tool.setSize(radius);
        if (args.hasFlag('h')) {
            tool.setBrush(new HollowSphereBrush(), "worldedit.brush.sphere");
        } else {
            tool.setBrush(new SphereBrush(), "worldedit.brush.sphere");
        }
        player.print(String.format("Sphere brush shape equipped (%.0f).", radius));
    }

    @Command(aliases={"cylinder", "cyl", "c"}, usage="<block> [radius] [height]", flags="h", desc="Choose the cylinder brush", help="Chooses the cylinder brush.\nThe -h flag creates hollow cylinders instead.", min=1, max=3)
    @CommandPermissions(value={"worldedit.brush.cylinder"})
    public void cylinderBrush(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int height;
        double radius;
        LocalConfiguration config = this.we.getConfiguration();
        double d = radius = args.argsLength() > 1 ? args.getDouble(1) : 2.0;
        if (radius > (double)config.maxBrushRadius) {
            player.printError("Maximum allowed brush radius: " + config.maxBrushRadius);
            return;
        }
        int n = height = args.argsLength() > 2 ? args.getInteger(2) : 1;
        if (height > config.maxBrushRadius) {
            player.printError("Maximum allowed brush radius/height: " + config.maxBrushRadius);
            return;
        }
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        Pattern fill = this.we.getBlockPattern(player, args.getString(0));
        tool.setFill(fill);
        tool.setSize(radius);
        if (args.hasFlag('h')) {
            tool.setBrush(new HollowCylinderBrush(height), "worldedit.brush.cylinder");
        } else {
            tool.setBrush(new CylinderBrush(height), "worldedit.brush.cylinder");
        }
        player.print(String.format("Cylinder brush shape equipped (%.0f by %d).", radius, height));
    }

    @Command(aliases={"clipboard", "copy"}, usage="", flags="a", desc="Choose the clipboard brush", help="Chooses the clipboard brush.\nThe -a flag makes it not paste air.", min=0, max=0)
    @CommandPermissions(value={"worldedit.brush.clipboard"})
    public void clipboardBrush(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        CuboidClipboard clipboard = session.getClipboard();
        if (clipboard == null) {
            player.printError("Copy something first.");
            return;
        }
        Vector size = clipboard.getSize();
        if (size.getBlockX() > config.maxBrushRadius || size.getBlockY() > config.maxBrushRadius || size.getBlockZ() > config.maxBrushRadius) {
            player.printError("Maximum allowed brush radius/height: " + config.maxBrushRadius);
            return;
        }
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        tool.setBrush(new ClipboardBrush(clipboard, args.hasFlag('a')), "worldedit.brush.clipboard");
        player.print("Clipboard brush shape equipped.");
    }

    @Command(aliases={"smooth"}, usage="[size] [iterations]", flags="n", desc="Choose the terrain softener brush", help="Chooses the terrain softener brush.\nThe -n flag makes it only consider naturally occuring blocks.", min=0, max=2)
    @CommandPermissions(value={"worldedit.brush.smooth"})
    public void smoothBrush(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radius;
        LocalConfiguration config = this.we.getConfiguration();
        double d = radius = args.argsLength() > 0 ? args.getDouble(0) : 2.0;
        if (radius > (double)config.maxBrushRadius) {
            player.printError("Maximum allowed brush radius: " + config.maxBrushRadius);
            return;
        }
        int iterations = args.argsLength() > 1 ? args.getInteger(1) : 4;
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        tool.setSize(radius);
        tool.setBrush(new SmoothBrush(iterations, args.hasFlag('n')), "worldedit.brush.smooth");
        player.print(String.format("Smooth brush equipped (%.0f x %dx, using " + (args.hasFlag('n') ? "natural blocks only" : "any block") + ").", radius, iterations));
    }

    @Command(aliases={"ex", "extinguish"}, usage="[radius]", desc="Shortcut fire extinguisher brush", min=0, max=1)
    @CommandPermissions(value={"worldedit.brush.ex"})
    public void extinguishBrush(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radius;
        LocalConfiguration config = this.we.getConfiguration();
        double d = radius = args.argsLength() > 1 ? args.getDouble(1) : 5.0;
        if (radius > (double)config.maxBrushRadius) {
            player.printError("Maximum allowed brush radius: " + config.maxBrushRadius);
            return;
        }
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        SingleBlockPattern fill = new SingleBlockPattern(new BaseBlock(0));
        tool.setFill(fill);
        tool.setSize(radius);
        tool.setMask(new BlockMask(new BaseBlock(51)));
        tool.setBrush(new SphereBrush(), "worldedit.brush.ex");
        player.print(String.format("Extinguisher equipped (%.0f).", radius));
    }

    @Command(aliases={"gravity", "grav"}, usage="[radius]", flags="h", desc="Gravity brush", help="This brush simulates the affect of gravity.\nThe -h flag makes it affect blocks starting at the world's max y, instead of the clicked block's y + radius.", min=0, max=1)
    @CommandPermissions(value={"worldedit.brush.gravity"})
    public void gravityBrush(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radius;
        LocalConfiguration config = this.we.getConfiguration();
        double d = radius = args.argsLength() > 0 ? args.getDouble(0) : 5.0;
        if (radius > (double)config.maxBrushRadius) {
            player.printError("Maximum allowed brush radius: " + config.maxBrushRadius);
            return;
        }
        BrushTool tool = session.getBrushTool(player.getItemInHand());
        tool.setSize(radius);
        tool.setBrush(new GravityBrush(args.hasFlag('h')), "worldedit.brush.gravity");
        player.print(String.format("Gravity brush equipped (%.0f).", radius));
    }
}

