/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.cui.CUIEvent;
import com.sk89q.worldedit.spout.SpoutPlayerBlockBag;
import com.sk89q.worldedit.spout.SpoutUtil;
import com.sk89q.worldedit.spout.WorldEditCUIMessage;
import com.sk89q.worldedit.spout.WorldEditPlugin;
import org.spout.api.Client;
import org.spout.api.chat.style.ChatStyle;
import org.spout.api.entity.Controller;
import org.spout.api.entity.Player;
import org.spout.api.geo.discrete.Point;
import org.spout.api.inventory.ItemStack;
import org.spout.api.protocol.Message;
import org.spout.vanilla.entity.VanillaPlayerController;
import org.spout.vanilla.material.VanillaMaterial;
import org.spout.vanilla.material.VanillaMaterials;

public class SpoutPlayer
extends LocalPlayer {
    private Player player;
    private WorldEditPlugin plugin;

    public SpoutPlayer(WorldEditPlugin plugin, ServerInterface server, Player player) {
        super(server);
        this.plugin = plugin;
        this.player = player;
    }

    @Override
    public int getItemInHand() {
        Controller controller = this.player.getController();
        if (controller instanceof VanillaPlayerController) {
            ItemStack itemStack = ((VanillaPlayerController)controller).getInventory().getQuickbar().getCurrentItem();
            return itemStack != null ? ((VanillaMaterial)itemStack.getMaterial()).getMinecraftId() : 0;
        }
        return 0;
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public WorldVector getPosition() {
        Point loc = this.player.getPosition();
        return new WorldVector(SpoutUtil.getLocalWorld(loc.getWorld()), loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public double getPitch() {
        return this.player.getPitch();
    }

    @Override
    public double getYaw() {
        return this.player.getYaw();
    }

    @Override
    public void giveItem(int type, int amt) {
        Controller controller = this.player.getController();
        if (controller instanceof VanillaPlayerController) {
            ((VanillaPlayerController)controller).getInventory().addItem(new ItemStack(VanillaMaterials.getMaterial((short)((short)type)), amt), false);
        }
    }

    @Override
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(new Object[]{part});
        }
    }

    @Override
    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(new Object[]{ChatStyle.PINK, part});
        }
    }

    @Override
    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(new Object[]{ChatStyle.GRAY, part});
        }
    }

    @Override
    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(new Object[]{ChatStyle.RED, part});
        }
    }

    @Override
    public void setPosition(Vector pos, float pitch, float yaw) {
        this.player.setPosition(SpoutUtil.toPoint(this.player.getWorld(), pos));
        this.player.setPitch(pitch);
        this.player.setYaw(yaw);
        this.player.getNetworkSynchronizer().setPositionDirty();
    }

    @Override
    public String[] getGroups() {
        return this.player.getGroups();
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return new SpoutPlayerBlockBag(this.player);
    }

    @Override
    public boolean hasPermission(String perm) {
        return this.player.hasPermission(perm);
    }

    @Override
    public LocalWorld getWorld() {
        return SpoutUtil.getLocalWorld(this.player.getWorld());
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        this.player.getSession().send(this.player.getSession().getEngine() instanceof Client, (Message)new WorldEditCUIMessage(event));
    }

    public Player getPlayer() {
        return this.player;
    }
}

