/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.spout;

import com.sk89q.worldedit.BiomeType;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EntityType;
import com.sk89q.worldedit.LocalEntity;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.spout.SpoutBiomeType;
import com.sk89q.worldedit.spout.SpoutEntity;
import com.sk89q.worldedit.spout.SpoutUtil;
import com.sk89q.worldedit.spout.WorldEditPlugin;
import com.sk89q.worldedit.util.TreeGenerator;
import java.util.ArrayList;
import org.spout.api.Source;
import org.spout.api.entity.Controller;
import org.spout.api.entity.Entity;
import org.spout.api.generator.biome.BiomeGenerator;
import org.spout.api.geo.LoadOption;
import org.spout.api.geo.World;
import org.spout.api.geo.cuboid.Chunk;
import org.spout.api.inventory.ItemStack;
import org.spout.api.material.BlockMaterial;
import org.spout.api.material.Material;
import org.spout.api.math.Vector3;
import org.spout.vanilla.entity.object.moving.Item;
import org.spout.vanilla.entity.object.moving.PrimedTnt;
import org.spout.vanilla.entity.object.projectile.Arrow;
import org.spout.vanilla.entity.object.vehicle.Boat;
import org.spout.vanilla.entity.object.vehicle.Minecart;
import org.spout.vanilla.material.VanillaMaterial;
import org.spout.vanilla.material.VanillaMaterials;
import org.spout.vanilla.world.generator.normal.object.tree.SmallTreeObject;

public class SpoutWorld
extends LocalWorld {
    private World world;

    public SpoutWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public String getName() {
        return this.world.getName();
    }

    @Override
    public boolean setBlockType(Vector pt, int type) {
        Material mat = VanillaMaterials.getMaterial((short)((short)type));
        if (mat != null && mat instanceof BlockMaterial) {
            return this.world.setBlockMaterial(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ(), (BlockMaterial)mat, (short)0, (Source)WorldEditPlugin.getInstance());
        }
        return false;
    }

    @Override
    public boolean setBlockTypeFast(Vector pt, int type) {
        return this.setBlockType(pt, type);
    }

    @Override
    public boolean setTypeIdAndData(Vector pt, int type, int data) {
        Material mat = VanillaMaterials.getMaterial((short)((short)type));
        if (mat != null && mat instanceof BlockMaterial) {
            return this.world.setBlockMaterial(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ(), (BlockMaterial)mat, (short)data, (Source)WorldEditPlugin.getInstance());
        }
        return false;
    }

    @Override
    public boolean setTypeIdAndDataFast(Vector pt, int type, int data) {
        return this.setTypeIdAndData(pt, type, data);
    }

    @Override
    public int getBlockType(Vector pt) {
        BlockMaterial mat = this.world.getBlockMaterial(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        return mat instanceof VanillaMaterial ? ((VanillaMaterial)mat).getMinecraftId() : 0;
    }

    @Override
    public void setBlockData(Vector pt, int data) {
        this.world.setBlockData(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ(), (short)data, (Source)WorldEditPlugin.getInstance());
    }

    @Override
    public void setBlockDataFast(Vector pt, int data) {
        this.setBlockData(pt, data);
    }

    @Override
    public int getBlockData(Vector pt) {
        return this.world.getBlockData(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
    }

    @Override
    public int getBlockLightLevel(Vector pt) {
        return this.world.getBlockLight(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
    }

    @Override
    public BiomeType getBiome(Vector2D pt) {
        if (this.world.getGenerator() instanceof BiomeGenerator) {
            BiomeGenerator gen = (BiomeGenerator)this.world.getGenerator();
            return new SpoutBiomeType(gen.getBiome(pt.getBlockX(), pt.getBlockZ(), this.world.getSeed()));
        }
        return BiomeType.UNKNOWN;
    }

    @Override
    public void setBiome(Vector2D pt, BiomeType biome) {
        if (biome instanceof SpoutBiomeType && this.world.getGenerator() instanceof BiomeGenerator) {
            throw new UnsupportedOperationException("Biome changing is not yet supported in Spout");
        }
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        return false;
    }

    @Override
    public boolean copyToWorld(Vector pt, BaseBlock block) {
        return false;
    }

    @Override
    public boolean copyFromWorld(Vector pt, BaseBlock block) {
        return false;
    }

    @Override
    public boolean clearContainerBlockContents(Vector pt) {
        return false;
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector pt) throws MaxChangedBlocksException {
        SmallTreeObject tree = new SmallTreeObject();
        if (!tree.canPlaceObject(this.world, pt.getBlockX(), pt.getBlockY(), pt.getBlockZ())) {
            return false;
        }
        tree.placeObject(this.world, pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        return true;
    }

    @Override
    public void dropItem(Vector pt, BaseItemStack item) {
        Material mat = VanillaMaterials.getMaterial((short)((short)item.getType()));
        if (mat.hasSubMaterials()) {
            mat = mat.getSubMaterial(item.getData());
        }
        ItemStack spoutItem = new ItemStack(mat, (int)item.getData(), item.getAmount());
        this.world.createAndSpawnEntity(SpoutUtil.toPoint(this.world, pt), (Controller)new Item(spoutItem, new Vector3(pt.getX(), pt.getY(), pt.getZ())));
    }

    @Override
    public int killMobs(Vector origin, double radius, int flags) {
        int num = 0;
        return num;
    }

    @Override
    public int removeEntities(EntityType type, Vector origin, int radius) {
        int num = 0;
        double radiusSq = radius * radius;
        for (Entity ent : this.world.getAll()) {
            if (radius != -1 && origin.distanceSq(SpoutUtil.toVector(ent.getPosition())) > radiusSq) continue;
            if (type == EntityType.ARROWS) {
                if (!(ent.getController() instanceof Arrow)) continue;
                ent.kill();
                ++num;
                continue;
            }
            if (type == EntityType.BOATS) {
                if (!(ent.getController() instanceof Boat)) continue;
                ent.kill();
                ++num;
                continue;
            }
            if (type == EntityType.ITEMS) {
                if (!(ent.getController() instanceof Item)) continue;
                ent.kill();
                ++num;
                continue;
            }
            if (type == EntityType.MINECARTS) {
                if (!(ent.getController() instanceof Minecart)) continue;
                ent.kill();
                ++num;
                continue;
            }
            if (type != EntityType.TNT || !(ent.getController() instanceof PrimedTnt)) continue;
            ent.kill();
            ++num;
        }
        return num;
    }

    @Override
    public boolean isValidBlockType(int type) {
        return VanillaMaterials.getMaterial((short)((short)type)) instanceof BlockMaterial;
    }

    @Override
    public void checkLoadedChunk(Vector pt) {
        this.world.getChunk(pt.getBlockX() << Chunk.BLOCKS.BITS, pt.getBlockY() << Chunk.BLOCKS.BITS, pt.getBlockZ() << Chunk.BLOCKS.BITS);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SpoutWorld)) {
            return false;
        }
        return ((SpoutWorld)other).world.equals(this.world);
    }

    @Override
    public int hashCode() {
        return this.world.hashCode();
    }

    @Override
    public int getMaxY() {
        return this.world.getHeight() - 1;
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2D> chunks) {
    }

    @Override
    public boolean playEffect(Vector position, int type, int data) {
        return false;
    }

    public SpoutEntity[] getEntities(Region region) {
        ArrayList<SpoutEntity> entities = new ArrayList<SpoutEntity>();
        for (Vector pt : region.getChunkCubes()) {
            Chunk chunk = this.world.getChunk(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ(), LoadOption.NO_LOAD);
            if (chunk == null) continue;
            for (Entity ent : chunk.getEntities()) {
                if (!region.contains(SpoutUtil.toVector(ent.getPosition()))) continue;
                entities.add(new SpoutEntity(SpoutUtil.toLocation(ent), ent.getId(), ent.getController()));
            }
        }
        return entities.toArray(new SpoutEntity[entities.size()]);
    }

    @Override
    public int killEntities(LocalEntity ... entities) {
        int amount = 0;
        for (LocalEntity weEnt : entities) {
            SpoutEntity entity = (SpoutEntity)weEnt;
            Entity spoutEntity = this.world.getEntity(entity.getEntityId());
            if (spoutEntity == null) continue;
            spoutEntity.kill();
            ++amount;
        }
        return amount;
    }
}

