/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.Countable;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalEntity;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CuboidClipboard {
    private BaseBlock[][][] data;
    private Vector offset;
    private Vector origin;
    private Vector size;
    private List<CopiedEntity> entities = new ArrayList<CopiedEntity>();

    public CuboidClipboard(Vector size) {
        this.size = size;
        this.data = new BaseBlock[size.getBlockX()][size.getBlockY()][size.getBlockZ()];
        this.origin = new Vector();
        this.offset = new Vector();
    }

    public CuboidClipboard(Vector size, Vector origin) {
        this.size = size;
        this.data = new BaseBlock[size.getBlockX()][size.getBlockY()][size.getBlockZ()];
        this.origin = origin;
        this.offset = new Vector();
    }

    public CuboidClipboard(Vector size, Vector origin, Vector offset) {
        this.size = size;
        this.data = new BaseBlock[size.getBlockX()][size.getBlockY()][size.getBlockZ()];
        this.origin = origin;
        this.offset = offset;
    }

    public int getWidth() {
        return this.size.getBlockX();
    }

    public int getLength() {
        return this.size.getBlockZ();
    }

    public int getHeight() {
        return this.size.getBlockY();
    }

    public void rotate2D(int angle) {
        if ((angle %= 360) % 90 != 0) {
            return;
        }
        boolean reverse = angle < 0;
        int numRotations = Math.abs((int)Math.floor((double)angle / 90.0));
        int width = this.getWidth();
        int length = this.getLength();
        int height = this.getHeight();
        Vector sizeRotated = this.size.transform2D(angle, 0.0, 0.0, 0.0, 0.0);
        int shiftX = sizeRotated.getX() < 0.0 ? -sizeRotated.getBlockX() - 1 : 0;
        int shiftZ = sizeRotated.getZ() < 0.0 ? -sizeRotated.getBlockZ() - 1 : 0;
        BaseBlock[][][] newData = new BaseBlock[Math.abs(sizeRotated.getBlockX())][Math.abs(sizeRotated.getBlockY())][Math.abs(sizeRotated.getBlockZ())];
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                Vector v = new Vector(x, 0, z).transform2D(angle, 0.0, 0.0, 0.0, 0.0);
                int newX = v.getBlockX();
                int newZ = v.getBlockZ();
                for (int y = 0; y < height; ++y) {
                    int i;
                    BaseBlock block;
                    newData[shiftX + newX][y][shiftZ + newZ] = block = this.data[x][y][z];
                    if (reverse) {
                        for (i = 0; i < numRotations; ++i) {
                            block.rotate90Reverse();
                        }
                        continue;
                    }
                    for (i = 0; i < numRotations; ++i) {
                        block.rotate90();
                    }
                }
            }
        }
        this.data = newData;
        this.size = new Vector(Math.abs(sizeRotated.getBlockX()), Math.abs(sizeRotated.getBlockY()), Math.abs(sizeRotated.getBlockZ()));
        this.offset = this.offset.transform2D(angle, 0.0, 0.0, 0.0, 0.0).subtract(shiftX, 0, shiftZ);
    }

    public void flip(FlipDirection dir) {
        this.flip(dir, false);
    }

    public void flip(FlipDirection dir, boolean aroundPlayer) {
        int width = this.getWidth();
        int length = this.getLength();
        int height = this.getHeight();
        switch (dir) {
            case NORTH_SOUTH: {
                int wid = (int)Math.ceil((float)width / 2.0f);
                for (int xs = 0; xs < wid; ++xs) {
                    for (int z = 0; z < length; ++z) {
                        for (int y = 0; y < height; ++y) {
                            BaseBlock old = this.data[xs][y][z].flip(dir);
                            if (xs == width - xs - 1) continue;
                            this.data[xs][y][z] = this.data[width - xs - 1][y][z].flip(dir);
                            this.data[width - xs - 1][y][z] = old;
                        }
                    }
                }
                if (!aroundPlayer) break;
                this.offset = this.offset.setX(1.0 - this.offset.getX() - (double)width);
                break;
            }
            case WEST_EAST: {
                int len = (int)Math.ceil((float)length / 2.0f);
                for (int zs = 0; zs < len; ++zs) {
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            BaseBlock old = this.data[x][y][zs].flip(dir);
                            if (zs == length - zs - 1) continue;
                            this.data[x][y][zs] = this.data[x][y][length - zs - 1].flip(dir);
                            this.data[x][y][length - zs - 1] = old;
                        }
                    }
                }
                if (!aroundPlayer) break;
                this.offset = this.offset.setZ(1.0 - this.offset.getZ() - (double)length);
                break;
            }
            case UP_DOWN: {
                int hei = (int)Math.ceil((float)height / 2.0f);
                for (int ys = 0; ys < hei; ++ys) {
                    for (int x = 0; x < width; ++x) {
                        for (int z = 0; z < length; ++z) {
                            BaseBlock old = this.data[x][ys][z].flip(dir);
                            if (ys == height - ys - 1) continue;
                            this.data[x][ys][z] = this.data[x][height - ys - 1][z].flip(dir);
                            this.data[x][height - ys - 1][z] = old;
                        }
                    }
                }
                if (!aroundPlayer) break;
                this.offset = this.offset.setY(1.0 - this.offset.getY() - (double)height);
            }
        }
    }

    public void copy(EditSession editSession) {
        for (int x = 0; x < this.size.getBlockX(); ++x) {
            for (int y = 0; y < this.size.getBlockY(); ++y) {
                for (int z = 0; z < this.size.getBlockZ(); ++z) {
                    this.data[x][y][z] = editSession.getBlock(new Vector(x, y, z).add(this.getOrigin()));
                }
            }
        }
    }

    public void paste(EditSession editSession, Vector newOrigin, boolean noAir) throws MaxChangedBlocksException {
        this.paste(editSession, newOrigin, noAir, false);
    }

    public void paste(EditSession editSession, Vector newOrigin, boolean noAir, boolean entities) throws MaxChangedBlocksException {
        this.place(editSession, newOrigin.add(this.offset), noAir);
        if (entities) {
            this.pasteEntities(newOrigin.add(this.offset));
        }
    }

    public void place(EditSession editSession, Vector pos, boolean noAir) throws MaxChangedBlocksException {
        for (int x = 0; x < this.size.getBlockX(); ++x) {
            for (int y = 0; y < this.size.getBlockY(); ++y) {
                for (int z = 0; z < this.size.getBlockZ(); ++z) {
                    if (noAir && this.data[x][y][z].isAir()) continue;
                    editSession.setBlock(new Vector(x, y, z).add(pos), this.data[x][y][z]);
                }
            }
        }
    }

    public LocalEntity[] pasteEntities(Vector pos) {
        LocalEntity[] entities = new LocalEntity[this.entities.size()];
        for (int i = 0; i < this.entities.size(); ++i) {
            CopiedEntity copied = this.entities.get(i);
            if (!copied.entity.spawn(copied.entity.getPosition().setPosition(copied.relativePosition.add(pos)))) continue;
            entities[i] = copied.entity;
        }
        return entities;
    }

    public void storeEntity(LocalEntity entity) {
        this.entities.add(new CopiedEntity(entity));
    }

    public BaseBlock getPoint(Vector pos) throws ArrayIndexOutOfBoundsException {
        return this.data[pos.getBlockX()][pos.getBlockY()][pos.getBlockZ()];
    }

    public void setBlock(Vector pt, BaseBlock block) {
        this.data[pt.getBlockX()][pt.getBlockY()][pt.getBlockZ()] = block;
    }

    public Vector getSize() {
        return this.size;
    }

    @Deprecated
    public void saveSchematic(File path) throws IOException, DataException {
        SchematicFormat.MCEDIT.save(this, path);
    }

    @Deprecated
    public static CuboidClipboard loadSchematic(File path) throws DataException, IOException {
        return SchematicFormat.MCEDIT.load(path);
    }

    public Vector getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector origin) {
        this.origin = origin;
    }

    public Vector getOffset() {
        return this.offset;
    }

    public void setOffset(Vector offset) {
        this.offset = offset;
    }

    public List<Countable<Integer>> getBlockDistribution() {
        ArrayList<Countable<Integer>> distribution = new ArrayList<Countable<Integer>>();
        HashMap<Integer, Countable<Integer>> map = new HashMap<Integer, Countable<Integer>>();
        int maxX = this.getWidth();
        int maxY = this.getHeight();
        int maxZ = this.getLength();
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < maxY; ++y) {
                for (int z = 0; z < maxZ; ++z) {
                    int id = this.data[x][y][z].getId();
                    if (map.containsKey(id)) {
                        ((Countable)map.get(id)).increment();
                        continue;
                    }
                    Countable<Integer> c = new Countable<Integer>(id, 1);
                    map.put(id, c);
                    distribution.add(c);
                }
            }
        }
        Collections.sort(distribution);
        return distribution;
    }

    private class CopiedEntity {
        private final LocalEntity entity;
        private final Vector relativePosition;

        public CopiedEntity(LocalEntity entity) {
            this.entity = entity;
            this.relativePosition = entity.getPosition().getPosition().subtract(CuboidClipboard.this.getOrigin());
        }
    }

    public static enum FlipDirection {
        NORTH_SOUTH,
        WEST_EAST,
        UP_DOWN;

    }
}

